/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.progvalidation;

import com.indeed.vw.wrapper.progvalidation.ProgressiveValidation;

public class PrecisionValidation
extends ProgressiveValidation {
    private final double decisionThreashold;
    private double truePositives = 0.0;
    private double falsePositives = 0.0;

    public PrecisionValidation(double decisionThreshold) {
        super("Pr", true);
        this.decisionThreashold = decisionThreshold;
    }

    @Override
    public synchronized double getScore() {
        if (this.truePositives + this.falsePositives == 0.0) {
            return 0.0;
        }
        return this.truePositives / (this.truePositives + this.falsePositives);
    }

    @Override
    public synchronized void updateScore(double prediction, double actual) {
        boolean predictionPositive;
        boolean actualPositive = actual > 1.0E-13;
        boolean bl = predictionPositive = prediction > this.decisionThreashold;
        if (actualPositive && predictionPositive) {
            this.truePositives += 1.0;
        }
        if (!actualPositive && predictionPositive) {
            this.falsePositives += 1.0;
        }
    }
}

