/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.progvalidation;

import com.google.common.base.Joiner;
import com.indeed.vw.wrapper.progvalidation.AccuracyValidation;
import com.indeed.vw.wrapper.progvalidation.FOneScoreValidation;
import com.indeed.vw.wrapper.progvalidation.LogLossValidation;
import com.indeed.vw.wrapper.progvalidation.MAEValidation;
import com.indeed.vw.wrapper.progvalidation.ProgressiveValidation;
import com.indeed.vw.wrapper.progvalidation.RMSEValidation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Metrics {
    private final List<ProgressiveValidation> validationMetrics;
    private static final Logger logger = Logger.getLogger(ProgressiveValidation.class);
    protected int examplesCount = 0;
    private final int printScoreEveryNExamples;

    public static Metrics regressionMetrics(int printEveryN) {
        return new Metrics(printEveryN, new RMSEValidation(), new MAEValidation());
    }

    public static Metrics zeroOneClassificationMetrics(int printEveryN, double decisionThreshold) {
        return new Metrics(printEveryN, new AccuracyValidation(decisionThreshold), new FOneScoreValidation(decisionThreshold));
    }

    public static Metrics probabilityClassificationMetrics(int printEveryN) {
        return new Metrics(printEveryN, new LogLossValidation());
    }

    public Metrics(int printScoreEveryNExamples, ProgressiveValidation ... validationMetrics) {
        this.printScoreEveryNExamples = printScoreEveryNExamples;
        this.validationMetrics = Arrays.asList(validationMetrics);
    }

    public synchronized void updateScore(double prediction, double actual) {
        for (ProgressiveValidation metric : this.validationMetrics) {
            metric.updateScore(prediction, actual);
        }
        ++this.examplesCount;
        if (this.printScoreEveryNExamples > 0 && this.examplesCount % this.printScoreEveryNExamples == 0) {
            this.printScores();
        }
    }

    public synchronized void printScores() {
        logger.info((Object)("#Examples=" + this.examplesCount + "\t- " + Joiner.on((char)'\t').join(this.validationMetrics)));
    }

    public synchronized Map<String, Double> getScores() {
        HashMap<String, Double> scores = new HashMap<String, Double>();
        for (ProgressiveValidation metric : this.validationMetrics) {
            scores.put(metric.getMetric(), metric.getScore());
        }
        return scores;
    }
}

