/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperConnection {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperConnection.class);
    private ZooKeeper zooKeeper;
    private final String zookeeperNodes;
    private final int timeout;

    public ZooKeeperConnection(String zookeeperNodes, int timeout) {
        this.zookeeperNodes = zookeeperNodes;
        this.timeout = timeout;
    }

    public void connect() throws IOException, InterruptedException {
        final AtomicReference<Object> connectionState = new AtomicReference<Object>(null);
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                connectionState.set(watchedEvent.getState());
            }
        };
        this.zooKeeper = new ZooKeeper(this.zookeeperNodes, this.timeout, watcher);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)this.timeout && connectionState.get() == null) {
            Thread.sleep(500L);
        }
        if (connectionState.get() != Watcher.Event.KeeperState.SyncConnected) {
            this.zooKeeper.close();
            throw new IOException("connection failed");
        }
    }

    public boolean isConnected() {
        return this.zooKeeper != null && this.zooKeeper.getState().isAlive();
    }

    public long getSessionId() {
        return this.zooKeeper.getSessionId();
    }

    public byte[] getSessionPasswd() {
        return this.zooKeeper.getSessionPasswd();
    }

    public int getSessionTimeout() {
        return this.zooKeeper.getSessionTimeout();
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        this.zooKeeper.addAuthInfo(scheme, auth);
    }

    public void register(Watcher watcher) {
        this.zooKeeper.register(watcher);
    }

    public void close() throws InterruptedException {
        if (this.zooKeeper != null) {
            this.zooKeeper.close();
        }
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.zooKeeper.create(path, data, acl, createMode);
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this.zooKeeper.create(path, data, acl, createMode, cb, ctx);
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.zooKeeper.delete(path, version);
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this.zooKeeper.delete(path, version, cb, ctx);
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.zooKeeper.exists(path, watcher);
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.zooKeeper.exists(path, watch);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.zooKeeper.exists(path, watcher, cb, ctx);
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.zooKeeper.exists(path, watch, cb, ctx);
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.zooKeeper.getData(path, watcher, stat);
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.zooKeeper.getData(path, watch, stat);
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.zooKeeper.getData(path, watcher, cb, ctx);
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.zooKeeper.getData(path, watch, cb, ctx);
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.zooKeeper.setData(path, data, version);
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.zooKeeper.setData(path, data, version, cb, ctx);
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        return this.zooKeeper.getACL(path, stat);
    }

    public void getACL(String path, Stat stat, AsyncCallback.ACLCallback cb, Object ctx) {
        this.zooKeeper.getACL(path, stat, cb, ctx);
    }

    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        return this.zooKeeper.setACL(path, acl, version);
    }

    public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.zooKeeper.setACL(path, acl, version, cb, ctx);
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.zooKeeper.getChildren(path, watcher);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.zooKeeper.getChildren(path, watch);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.zooKeeper.getChildren(path, watcher, cb, ctx);
    }

    public void getChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.zooKeeper.getChildren(path, watch, cb, ctx);
    }

    public List<String> getChildren(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.zooKeeper.getChildren(path, watcher, stat);
    }

    public List<String> getChildren(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.zooKeeper.getChildren(path, watch, stat);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.zooKeeper.getChildren(path, watcher, cb, ctx);
    }

    public void getChildren(String path, boolean watch, AsyncCallback.Children2Callback cb, Object ctx) {
        this.zooKeeper.getChildren(path, watch, cb, ctx);
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.zooKeeper.sync(path, cb, ctx);
    }

    public ZooKeeper.States getState() {
        return this.zooKeeper.getState();
    }

    public void createFullPath(String path, byte[] value, CreateMode createMode) throws KeeperException, InterruptedException {
        ZooKeeperConnection.createFullPath(this, path, value, createMode);
    }

    public boolean createFullPath(String path, byte[] value, CreateMode createMode, boolean ignoreIfExists) throws KeeperException, InterruptedException {
        return ZooKeeperConnection.createFullPath(this, path, value, createMode, ignoreIfExists);
    }

    public static void createFullPath(ZooKeeperConnection zooKeeperConnection, String path, byte[] value, CreateMode createMode) throws InterruptedException, KeeperException {
        ZooKeeperConnection.createFullPath(zooKeeperConnection, path, value, createMode, false);
    }

    public static boolean createFullPath(ZooKeeperConnection zooKeeperConnection, String path, byte[] value, CreateMode createMode, boolean ignoreIfExists) throws InterruptedException, KeeperException {
        byte[] empty = new byte[]{};
        String[] nodes = path.split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 1; i < nodes.length - 1; ++i) {
            pathBuilder.append("/").append(nodes[i]);
            ZooKeeperConnection.createIfNotExists(zooKeeperConnection, pathBuilder.toString(), empty, CreateMode.PERSISTENT);
        }
        pathBuilder.append("/").append(nodes[nodes.length - 1]);
        if (ignoreIfExists) {
            return ZooKeeperConnection.createIfNotExists(zooKeeperConnection, path, value, createMode);
        }
        zooKeeperConnection.create(pathBuilder.toString(), value, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        return true;
    }

    public boolean createIfNotExists(String path, byte[] value, CreateMode createMode) throws KeeperException, InterruptedException {
        return ZooKeeperConnection.createIfNotExists(this, path, value, createMode);
    }

    public static boolean createIfNotExists(ZooKeeperConnection zooKeeper, String path, byte[] value, CreateMode createMode) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path, false) == null) {
            try {
                zooKeeper.create(path, value, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
            }
            catch (KeeperException e) {
                if (e.code() != KeeperException.Code.NODEEXISTS) {
                    throw e;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateOrCreate(String path, byte[] value, CreateMode createMode) throws KeeperException, InterruptedException {
        ZooKeeperConnection.updateOrCreate(this, path, value, createMode);
    }

    public static void updateOrCreate(ZooKeeperConnection zooKeeper, String path, byte[] value, CreateMode createMode) throws InterruptedException, KeeperException {
        boolean success = false;
        if (zooKeeper.exists(path, false) == null) {
            success = ZooKeeperConnection.createFullPath(zooKeeper, path, value, createMode, true);
        }
        if (!success) {
            zooKeeper.setData(path, value, -1);
        }
    }

    public static String buildPath(String parent, String firstPart, String ... restOfParts) {
        PathUtils.validatePath((String)parent);
        if (firstPart.contains("/")) {
            throw new IllegalArgumentException("only parent may contain / character");
        }
        String path = (parent.equals("/") ? parent : parent + "/") + firstPart;
        for (String part : restOfParts) {
            if (part.contains("/")) {
                throw new IllegalArgumentException("only parent may contain / character");
            }
            path = path + "/" + part;
        }
        PathUtils.validatePath((String)path);
        return path;
    }

    public static String getName(String path) {
        PathUtils.validatePath((String)path);
        if (path.equals("/")) {
            throw new IllegalArgumentException("name of / is undefined");
        }
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public static String getParent(String path) {
        PathUtils.validatePath((String)path);
        if (path.equals("/")) {
            throw new IllegalArgumentException("parent of / is undefined");
        }
        int index = path.lastIndexOf(47);
        if (index == 0) {
            return "/";
        }
        return path.substring(0, index);
    }
}

