/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.list;

import com.google.common.base.Supplier;
import com.indeed.util.serialization.CollectionSuppliers;
import com.indeed.util.serialization.LengthVIntSerializer;
import com.indeed.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListSerializer<T>
implements Serializer<List<T>> {
    private static final Logger log = LoggerFactory.getLogger(ListSerializer.class);
    private static final LengthVIntSerializer lengthSerializer = new LengthVIntSerializer();
    private final Supplier<List<T>> listSupplier;
    private final Serializer<T> tSerializer;

    public static <T> ListSerializer<T> arrayListSerializer(Serializer<T> tSerializer) {
        return new ListSerializer<T>(new CollectionSuppliers.ArrayListSupplier(), tSerializer);
    }

    public ListSerializer(Supplier<List<T>> listSupplier, Serializer<T> tSerializer) {
        this.listSupplier = listSupplier;
        this.tSerializer = tSerializer;
    }

    @Override
    public void write(List<T> list, DataOutput out) throws IOException {
        lengthSerializer.write(list.size(), out);
        for (T t : list) {
            this.tSerializer.write(t, out);
        }
    }

    @Override
    public List<T> read(DataInput in) throws IOException {
        List ret = (List)this.listSupplier.get();
        int size = lengthSerializer.read(in);
        for (int i = 0; i < size; ++i) {
            ret.add(this.tSerializer.read(in));
        }
        return ret;
    }
}

