/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import java.io.DataInput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryDataInput
implements DataInput {
    private static final Logger log = LoggerFactory.getLogger(MemoryDataInput.class);
    private final Memory memory;
    private long position = 0L;

    public MemoryDataInput(Memory memory) {
        this.memory = memory;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.memory.getBytes(this.position, b, off, len);
        this.position += (long)len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.position += (long)n;
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.memory.getByte(this.position++) != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.memory.getByte(this.position++);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        short ret = this.memory.getShort(this.position);
        this.position += 2L;
        return ret;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        char ret = this.memory.getChar(this.position);
        this.position += 2L;
        return ret;
    }

    @Override
    public int readInt() throws IOException {
        int ret = this.memory.getInt(this.position);
        this.position += 4L;
        return ret;
    }

    @Override
    public long readLong() throws IOException {
        long ret = this.memory.getLong(this.position);
        this.position += 8L;
        return ret;
    }

    @Override
    public float readFloat() throws IOException {
        float ret = this.memory.getFloat(this.position);
        this.position += 4L;
        return ret;
    }

    @Override
    public double readDouble() throws IOException {
        double ret = this.memory.getDouble(this.position);
        this.position += 8L;
        return ret;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public long length() {
        return this.memory.length();
    }
}

