/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.MMapBuffer;
import com.indeed.util.mmap.Memory;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicMMapBufferDataOutputStream
extends OutputStream
implements DataOutput {
    private static final Logger log = LoggerFactory.getLogger(DynamicMMapBufferDataOutputStream.class);
    private MMapBuffer buffer;
    private Memory memory;
    private final File file;
    private final ByteOrder byteOrder;
    private long currentAddress = 0L;
    private List<MMapBuffer> toClose = new ArrayList<MMapBuffer>();

    public DynamicMMapBufferDataOutputStream(File file, ByteOrder byteOrder) throws IOException {
        this.file = file;
        this.byteOrder = byteOrder;
        this.buffer = new MMapBuffer(file, 0L, 4096L, FileChannel.MapMode.READ_WRITE, byteOrder);
        this.memory = this.buffer.memory();
    }

    public DynamicMMapBufferDataOutputStream(File file, ByteOrder byteOrder, long offset) throws IOException {
        this.file = file;
        this.byteOrder = byteOrder;
        this.buffer = new MMapBuffer(file, 0L, Math.max(4096L, file.length()), FileChannel.MapMode.READ_WRITE, byteOrder);
        this.memory = this.buffer.memory();
        this.currentAddress = offset;
    }

    public DirectMemory memory() {
        return this.buffer.memory().slice(0L, this.currentAddress);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        try {
            this.memory.putByte(this.currentAddress, (byte)(v ? 1 : 0));
            ++this.currentAddress;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeBoolean(v);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        try {
            this.memory.putByte(this.currentAddress, (byte)v);
            ++this.currentAddress;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeByte(v);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        try {
            this.memory.putShort(this.currentAddress, (short)v);
            this.currentAddress += 2L;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeShort(v);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        try {
            this.memory.putChar(this.currentAddress, (char)v);
            this.currentAddress += 2L;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeChar(v);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            this.memory.putInt(this.currentAddress, v);
            this.currentAddress += 4L;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeInt(v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            this.memory.putLong(this.currentAddress, v);
            this.currentAddress += 8L;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeLong(v);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        try {
            this.memory.putFloat(this.currentAddress, v);
            this.currentAddress += 4L;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeFloat(v);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        try {
            this.memory.putDouble(this.currentAddress, v);
            this.currentAddress += 8L;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.writeDouble(v);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.memory.putBytes(this.currentAddress, b, off, len);
            this.currentAddress += (long)len;
        }
        catch (IndexOutOfBoundsException e) {
            this.toClose.add(this.buffer);
            this.buffer = new MMapBuffer(this.file, 0L, this.memory.length() * 2L, FileChannel.MapMode.READ_WRITE, this.byteOrder);
            this.memory = this.buffer.memory();
            this.write(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        for (MMapBuffer buffer : this.toClose) {
            buffer.close();
        }
        this.buffer.close();
    }

    public long position() {
        return this.currentAddress;
    }

    public void sync() throws IOException {
        this.buffer.sync(0L, this.currentAddress);
    }
}

