/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.AbstractMemory;
import com.indeed.util.mmap.DirectDataAccess;
import com.indeed.util.mmap.Memory;
import com.indeed.util.mmap.NativeEndianDirectDataAccess;
import com.indeed.util.mmap.NativeMemoryUtils;
import com.indeed.util.mmap.ReverseEndianDirectDataAccess;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectMemory
extends AbstractMemory {
    private static final Logger log = LoggerFactory.getLogger(DirectMemory.class);
    private static final boolean debug = true;
    private final ByteOrder order;
    private final DirectDataAccess directDataAccess;
    private final long address;
    private final long length;

    DirectMemory(long address, long length, ByteOrder order) {
        this.address = address;
        this.length = length;
        this.order = order;
        this.directDataAccess = order.equals(ByteOrder.nativeOrder()) ? NativeEndianDirectDataAccess.getInstance() : ReverseEndianDirectDataAccess.getInstance();
    }

    private void checkBounds(long l, long length) {
        if (l < 0L || l > this.length - length) {
            throw new IndexOutOfBoundsException("l: " + l + " length: " + length);
        }
    }

    private void checkArrayBounds(byte[] bytes, int start, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte[] bytes cannot be null");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("start cannot be less than zero");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be less than zero");
        }
        if (start + length > bytes.length) {
            throw new IndexOutOfBoundsException("start plus length cannot be greater than length of byte[] bytes");
        }
        if (start + length < 0) {
            throw new IndexOutOfBoundsException("start plus length cannot be greater than Integer.MAX_VALUE");
        }
    }

    @Override
    public byte getByte(long l) {
        this.checkBounds(l, 1L);
        return this.directDataAccess.getByte(this.address + l);
    }

    @Override
    public void putByte(long l, byte b) {
        this.checkBounds(l, 1L);
        this.directDataAccess.putByte(this.address + l, b);
    }

    @Override
    public short getShort(long l) {
        this.checkBounds(l, 2L);
        return this.directDataAccess.getShort(this.address + l);
    }

    @Override
    public void putShort(long l, short i) {
        this.checkBounds(l, 2L);
        this.directDataAccess.putShort(this.address + l, i);
    }

    @Override
    public char getChar(long l) {
        this.checkBounds(l, 2L);
        return this.directDataAccess.getChar(this.address + l);
    }

    @Override
    public void putChar(long l, char c) {
        this.checkBounds(l, 2L);
        this.directDataAccess.putChar(this.address + l, c);
    }

    @Override
    public int getInt(long l) {
        this.checkBounds(l, 4L);
        return this.directDataAccess.getInt(this.address + l);
    }

    @Override
    public void putInt(long l, int i) {
        this.checkBounds(l, 4L);
        this.directDataAccess.putInt(this.address + l, i);
    }

    @Override
    public long getLong(long l) {
        this.checkBounds(l, 8L);
        return this.directDataAccess.getLong(this.address + l);
    }

    @Override
    public void putLong(long l, long l1) {
        this.checkBounds(l, 8L);
        this.directDataAccess.putLong(this.address + l, l1);
    }

    @Override
    public float getFloat(long l) {
        this.checkBounds(l, 4L);
        return this.directDataAccess.getFloat(this.address + l);
    }

    @Override
    public void putFloat(long l, float v) {
        this.checkBounds(l, 4L);
        this.directDataAccess.putFloat(this.address + l, v);
    }

    @Override
    public double getDouble(long l) {
        this.checkBounds(l, 8L);
        return this.directDataAccess.getDouble(this.address + l);
    }

    @Override
    public void putDouble(long l, double v) {
        this.checkBounds(l, 8L);
        this.directDataAccess.putDouble(this.address + l, v);
    }

    @Override
    public void putBytes(long l, byte[] bytes) {
        this.putBytes(l, bytes, 0, bytes.length);
    }

    @Override
    public void putBytes(long l, byte[] bytes, int start, int length) {
        this.checkBounds(l, length);
        this.checkArrayBounds(bytes, start, length);
        NativeMemoryUtils.copyFromArray(bytes, start, this.address + l, length);
    }

    public void putBytes(long l, DirectMemory source) {
        this.putBytes(l, source, 0L, source.length());
    }

    public void putBytes(long l, DirectMemory source, long start, long length) {
        this.checkBounds(l, length);
        source.checkBounds(start, length);
        this.directDataAccess.copyMemory(source.address + start, this.address + l, length);
    }

    @Override
    public void putBytes(long l, Memory source) {
        this.putBytes(l, source, 0L, source.length());
    }

    @Override
    public void putBytes(long l, Memory source, long start, long length) {
        if (source.isDirect()) {
            this.putBytes(l, (DirectMemory)source, start, length);
        } else {
            source.getBytes(start, this, l, length);
        }
    }

    @Override
    public void putBytes(long l, ByteBuffer source) {
        int length = source.remaining();
        this.checkBounds(l, length);
        if (source.isDirect()) {
            NativeMemoryUtils.copyFromDirectBuffer(source, source.position(), this.address + l, length);
            source.position(source.position() + length);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offset = source.arrayOffset();
            this.putBytes(l, array, offset + source.position(), length);
            source.position(source.position() + length);
        } else {
            byte[] copyBuffer = new byte[Math.min(length, 4096)];
            long destAddr = l;
            while (source.remaining() > 0) {
                int copySize = Math.min(copyBuffer.length, source.remaining());
                source.get(copyBuffer, 0, copySize);
                this.putBytes(destAddr, copyBuffer, 0, copySize);
                destAddr += (long)copySize;
            }
        }
    }

    @Override
    public void getBytes(long l, byte[] bytes) {
        this.getBytes(l, bytes, 0, bytes.length);
    }

    @Override
    public void getBytes(long l, byte[] bytes, int start, int length) {
        this.checkBounds(l, length);
        this.checkArrayBounds(bytes, start, length);
        NativeMemoryUtils.copyToArray(this.address + l, bytes, start, length);
    }

    public void getBytes(long l, DirectMemory dest) {
        this.getBytes(l, dest, 0L, dest.length());
    }

    public void getBytes(long l, DirectMemory dest, long start, long length) {
        this.checkBounds(l, length);
        dest.checkBounds(start, length);
        this.directDataAccess.copyMemory(this.address + l, dest.address + start, length);
    }

    @Override
    public void getBytes(long l, Memory dest) {
        this.getBytes(l, dest, 0L, dest.length());
    }

    @Override
    public void getBytes(long l, Memory dest, long start, long length) {
        if (dest.isDirect()) {
            this.getBytes(l, (DirectMemory)dest, start, length);
        } else {
            dest.putBytes(start, this, l, length);
        }
    }

    @Override
    public void getBytes(long l, ByteBuffer dest) {
        int length = dest.remaining();
        this.checkBounds(l, length);
        if (dest.isDirect()) {
            NativeMemoryUtils.copyToDirectBuffer(this.address + l, dest, dest.position(), length);
            dest.position(dest.position() + length);
        } else if (dest.hasArray()) {
            byte[] array = dest.array();
            int offset = dest.arrayOffset();
            this.getBytes(l, array, offset + dest.position(), length);
            dest.position(dest.position() + length);
        } else {
            byte[] copyBuffer = new byte[Math.min(length, 4096)];
            long sourceAddr = l;
            while (dest.remaining() > 0) {
                int copySize = Math.min(copyBuffer.length, dest.remaining());
                this.getBytes(sourceAddr, copyBuffer, 0, copySize);
                dest.put(copyBuffer, 0, copySize);
                sourceAddr += (long)copySize;
            }
        }
    }

    @Override
    public DirectMemory slice(long startAddress, long sliceLength) {
        if (startAddress < 0L) {
            throw new IllegalArgumentException("startAddress must be >= 0");
        }
        if (sliceLength < 0L) {
            throw new IllegalArgumentException("sliceLength must be >= 0");
        }
        if (startAddress + sliceLength > this.length) {
            throw new IllegalArgumentException("startAddress+sliceLength must be <= length");
        }
        return new DirectMemory(this.address + startAddress, sliceLength, this.order);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public ByteOrder getOrder() {
        return this.order;
    }

    @Deprecated
    public long getAddress() {
        return this.address;
    }
}

