/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.LoadIndeedMMap;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

final class NativeMemoryUtils {
    private static final Logger log = Logger.getLogger(NativeMemoryUtils.class);
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final int ENOMEM = 1;
    private static final int EPERM = 2;
    private static final int EAGAIN = 3;
    private static final int EFAULT = 4;
    private static final int EINVAL = 5;

    NativeMemoryUtils() {
    }

    static void copyFromArray(byte[] src, int offset, long dstAddr, int length) {
        while (length > 0) {
            long size = (long)length > 0x100000L ? 0x100000L : (long)length;
            NativeMemoryUtils.copyFromByteArray(src, offset, (int)size, dstAddr);
            length = (int)((long)length - size);
            offset = (int)((long)offset + size);
            dstAddr += size;
        }
    }

    static void copyToArray(long srcAddr, byte[] dst, int offset, int length) {
        while (length > 0) {
            long size = (long)length > 0x100000L ? 0x100000L : (long)length;
            NativeMemoryUtils.copyToByteArray(srcAddr, (int)size, dst, offset);
            length = (int)((long)length - size);
            srcAddr += size;
            offset = (int)((long)offset + size);
        }
    }

    static void mlock(long addr, long len) {
        if (len < 0L) {
            throw new IndexOutOfBoundsException();
        }
        int err = NativeMemoryUtils.mlock0(addr, len);
        if (err != 0) {
            if (err == 3) {
                NativeMemoryUtils.mlock(addr, len);
                return;
            }
            throw new OutOfMemoryError();
        }
    }

    static void munlock(long addr, long len) {
        if (len < 0L) {
            throw new IndexOutOfBoundsException();
        }
        int err = NativeMemoryUtils.munlock0(addr, len);
        if (err != 0) {
            if (err == 3) {
                NativeMemoryUtils.munlock(addr, len);
                return;
            }
            throw new OutOfMemoryError();
        }
    }

    static void mincore(long addr, long length, DirectMemory memory) {
        int err = NativeMemoryUtils.mincore(addr, length, memory.getAddress());
        if (err != 0) {
            switch (err) {
                case 1: {
                    throw new IllegalArgumentException("illegal arguments: address: " + addr + " length: " + length + " vec: " + memory.getAddress());
                }
                case 3: {
                    NativeMemoryUtils.mincore(addr, length, memory);
                    return;
                }
                case 4: {
                    throw new IllegalArgumentException("memory at " + memory.getAddress() + " is not valid");
                }
                case 5: {
                    throw new IllegalArgumentException("address " + addr + " is not a multiple of the page size");
                }
            }
            throw new IllegalArgumentException("unknown error");
        }
    }

    static native void copyToDirectBuffer(long var0, ByteBuffer var2, int var3, int var4);

    static native void copyFromDirectBuffer(ByteBuffer var0, int var1, long var2, int var4);

    private static native void copyFromByteArray(byte[] var0, int var1, int var2, long var3);

    private static native void copyToByteArray(long var0, int var2, byte[] var3, int var4);

    private static native int mlock0(long var0, long var2);

    private static native int munlock0(long var0, long var2);

    private static native int mincore(long var0, long var2, long var4);

    static {
        LoadIndeedMMap.loadLibrary();
    }
}

