/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.apache.log4j.Logger;

public final class DoubleArray {
    private static final Logger log = Logger.getLogger(DoubleArray.class);
    private static final long TYPE_SIZE = 8L;
    private final Memory buffer;
    private final long length;

    public DoubleArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length * 8L > buffer.length()) {
            throw new IndexOutOfBoundsException(String.format("address+length*%d must be <= buffer.length()", 8L));
        }
        this.buffer = buffer.slice(address, length * 8L);
        this.length = length;
    }

    public double get(long index) {
        return this.buffer.getDouble(index * 8L);
    }

    public void get(long index, double[] doubles, int start, int length) {
        for (int i = 0; i < length; ++i) {
            doubles[start + i] = this.buffer.getDouble((index + (long)i) * 8L);
        }
    }

    public void get(long index, double[] doubles) {
        this.get(index, doubles, 0, doubles.length);
    }

    public void get(long index, DoubleArray doubles, long start, long length) {
        doubles.set(start, this, index, length);
    }

    public void get(long index, DoubleArray doubles) {
        this.get(index, doubles, 0L, doubles.length);
    }

    public void set(long index, double value) {
        this.buffer.putDouble(index * 8L, value);
    }

    public void set(long index, double[] doubles, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.putDouble((index + (long)i) * 8L, doubles[start + i]);
        }
    }

    public void set(long index, double[] doubles) {
        this.set(index, doubles, 0, doubles.length);
    }

    public void set(long index, DoubleArray doubles, long start, long length) {
        doubles.buffer.getBytes(index * 8L, this.buffer, start * 8L, length * 8L);
    }

    public void set(long index, DoubleArray doubles) {
        this.set(index, doubles, 0L, doubles.length);
    }

    public long length() {
        return this.length;
    }

    public DoubleArray slice(long start, long length) {
        return new DoubleArray(this.buffer, start * 8L, length);
    }
}

