/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Stat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class NativeFileUtils {
    private static final Logger log = Logger.getLogger(NativeFileUtils.class);

    public static long du(String path) throws IOException {
        return NativeFileUtils.du(new File(path));
    }

    public static long du(File path) throws IOException {
        Stat stat;
        try {
            stat = Stat.lstat(path);
        }
        catch (FileNotFoundException e) {
            return 0L;
        }
        if (stat.isDirectory()) {
            long sum = 0L;
            File[] files = path.listFiles();
            if (files == null) {
                return 0L;
            }
            for (File f : files) {
                sum += NativeFileUtils.du(f);
            }
            return sum + 512L * stat.getNumBlocks();
        }
        return 512L * stat.getNumBlocks();
    }
}

