/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.google.common.io.ByteStreams;
import com.indeed.util.mmap.MMapBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public final class LoadIndeedMMap {
    private static final Logger log = Logger.getLogger(LoadIndeedMMap.class);
    private static boolean loaded = false;

    public static synchronized void loadLibrary() {
        if (!loaded) {
            try {
                String osName = System.getProperty("os.name");
                String arch = System.getProperty("os.arch");
                String resourcePath = "/native/" + osName + "-" + arch + "/libindeedmmap.so.1.0.1";
                InputStream is = MMapBuffer.class.getResourceAsStream(resourcePath);
                if (is == null) {
                    throw new FileNotFoundException("unable to find libindeedmmap.so.1.0.1 at resource path " + resourcePath);
                }
                File tempFile = File.createTempFile("libindeedmmap", ".so");
                FileOutputStream os = new FileOutputStream(tempFile);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
                ((OutputStream)os).close();
                is.close();
                System.load(tempFile.getAbsolutePath());
                tempFile.delete();
            }
            catch (Throwable e) {
                log.warn((Object)"unable to load libindeedmmap using class loader, looking in java.library.path", e);
                System.loadLibrary("indeedmmap");
            }
            loaded = true;
        }
    }
}

