/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5InputStream
extends FilterInputStream {
    MessageDigest md5;

    public MD5InputStream(InputStream in) {
        super(in);
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.md5.update((byte)b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.md5.update(b, off, result);
        }
        return result;
    }

    public String getHashString() {
        String hash = new BigInteger(1, this.md5.digest()).toString(16);
        while (hash.length() < 32) {
            hash = "0" + hash;
        }
        return hash;
    }
}

