/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class Directories {
    @Nonnegative
    public static int count(@Nonnull Path dir) throws IOException {
        int n;
        block8: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
            try {
                n = Iterables.size(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException ex) {
                    throw ex.getCause();
                }
            }
            stream.close();
        }
        return n;
    }

    @Nonnull
    public static List<Path> list(@Nonnull Path dir) throws IOException {
        ArrayList<Path> contents = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                contents.add(entry);
            }
        }
        catch (DirectoryIteratorException ex) {
            throw ex.getCause();
        }
        return contents;
    }

    private Directories() {
    }
}

