/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VIntUtils {
    private static final Logger log = LoggerFactory.getLogger(VIntUtils.class);

    public static int writeVInt(OutputStream out, int i) throws IOException {
        if (i < 0) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7 & 0x7F | 0x80);
            out.write(i >>> 14 & 0x7F | 0x80);
            out.write(i >>> 21 & 0x7F | 0x80);
            out.write(i >>> 28);
            return 5;
        }
        if (i < 128) {
            out.write(i);
            return 1;
        }
        if (i < 16384) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7);
            return 2;
        }
        if (i < 0x200000) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7 & 0x7F | 0x80);
            out.write(i >>> 14);
            return 3;
        }
        if (i < 0x10000000) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7 & 0x7F | 0x80);
            out.write(i >>> 14 & 0x7F | 0x80);
            out.write(i >>> 21);
            return 4;
        }
        out.write(i & 0x7F | 0x80);
        out.write(i >>> 7 & 0x7F | 0x80);
        out.write(i >>> 14 & 0x7F | 0x80);
        out.write(i >>> 21 & 0x7F | 0x80);
        out.write(i >>> 28);
        return 5;
    }

    public static int readVInt(InputStream in) throws IOException {
        byte b = (byte)in.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = (byte)in.read();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static int writeSVInt(OutputStream out, int i) throws IOException {
        return VIntUtils.writeVInt(out, i << 1 ^ i >> 31);
    }

    public static int readSVInt(InputStream in) throws IOException {
        int i = VIntUtils.readVInt(in);
        return i >>> 1 ^ -(i & 1);
    }

    public static int writeVInt(DataOutput out, int i) throws IOException {
        if (i < 0) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7 & 0x7F | 0x80);
            out.write(i >>> 14 & 0x7F | 0x80);
            out.write(i >>> 21 & 0x7F | 0x80);
            out.write(i >>> 28);
            return 5;
        }
        if (i < 128) {
            out.write(i);
            return 1;
        }
        if (i < 16384) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7);
            return 2;
        }
        if (i < 0x200000) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7 & 0x7F | 0x80);
            out.write(i >>> 14);
            return 3;
        }
        if (i < 0x10000000) {
            out.write(i & 0x7F | 0x80);
            out.write(i >>> 7 & 0x7F | 0x80);
            out.write(i >>> 14 & 0x7F | 0x80);
            out.write(i >>> 21);
            return 4;
        }
        out.write(i & 0x7F | 0x80);
        out.write(i >>> 7 & 0x7F | 0x80);
        out.write(i >>> 14 & 0x7F | 0x80);
        out.write(i >>> 21 & 0x7F | 0x80);
        out.write(i >>> 28);
        return 5;
    }

    public static int readVInt(DataInput in) throws IOException {
        byte b = in.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static int writeSVInt(DataOutput out, int i) throws IOException {
        return VIntUtils.writeVInt(out, i << 1 ^ i >> 31);
    }

    public static int readSVInt(DataInput in) throws IOException {
        int i = VIntUtils.readVInt(in);
        return i >>> 1 ^ -(i & 1);
    }

    public static int getVIntLength(int i) {
        int ret = 0;
        do {
            ++ret;
        } while ((i >>>= 7) > 0);
        return ret;
    }

    public static int writeVInt64(OutputStream out, long i) throws IOException {
        if (i < 0L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35 & 0x7FL | 0x80L));
            out.write((int)(i >>> 42 & 0x7FL | 0x80L));
            out.write((int)(i >>> 49 & 0x7FL | 0x80L));
            out.write((int)(i >>> 56 & 0x7FL | 0x80L));
            out.write((int)(i >>> 63));
            return 10;
        }
        if (i < 128L) {
            out.write((int)i);
            return 1;
        }
        if (i < 16384L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7));
            return 2;
        }
        if (i < 0x200000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14));
            return 3;
        }
        if (i < 0x10000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21));
            return 4;
        }
        if (i < 0x800000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28));
            return 5;
        }
        if (i < 0x40000000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35));
            return 6;
        }
        if (i < 0x2000000000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35 & 0x7FL | 0x80L));
            out.write((int)(i >>> 42));
            return 7;
        }
        if (i < 0x100000000000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35 & 0x7FL | 0x80L));
            out.write((int)(i >>> 42 & 0x7FL | 0x80L));
            out.write((int)(i >>> 49));
            return 8;
        }
        out.write((int)(i & 0x7FL | 0x80L));
        out.write((int)(i >>> 7 & 0x7FL | 0x80L));
        out.write((int)(i >>> 14 & 0x7FL | 0x80L));
        out.write((int)(i >>> 21 & 0x7FL | 0x80L));
        out.write((int)(i >>> 28 & 0x7FL | 0x80L));
        out.write((int)(i >>> 35 & 0x7FL | 0x80L));
        out.write((int)(i >>> 42 & 0x7FL | 0x80L));
        out.write((int)(i >>> 49 & 0x7FL | 0x80L));
        out.write((int)(i >>> 56));
        return 9;
    }

    public static long readVInt64(InputStream in) throws IOException {
        byte b = (byte)in.read();
        long i = b & 0x7F;
        long shift = 7L;
        while ((b & 0x80) != 0) {
            b = (byte)in.read();
            i |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
        }
        return i;
    }

    public static int writeSVInt64(OutputStream out, long i) throws IOException {
        return VIntUtils.writeVInt64(out, i << 1 ^ i >> 63);
    }

    public static long readSVInt64(InputStream in) throws IOException {
        long i = VIntUtils.readVInt64(in);
        return i >>> 1 ^ -(i & 1L);
    }

    public static int writeVInt64(DataOutput out, long i) throws IOException {
        if (i < 0L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35 & 0x7FL | 0x80L));
            out.write((int)(i >>> 42 & 0x7FL | 0x80L));
            out.write((int)(i >>> 49 & 0x7FL | 0x80L));
            out.write((int)(i >>> 56 & 0x7FL | 0x80L));
            out.write((int)(i >>> 63));
            return 10;
        }
        if (i < 128L) {
            out.write((int)i);
            return 1;
        }
        if (i < 16384L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7));
            return 2;
        }
        if (i < 0x200000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14));
            return 3;
        }
        if (i < 0x10000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21));
            return 4;
        }
        if (i < 0x800000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28));
            return 5;
        }
        if (i < 0x40000000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35));
            return 6;
        }
        if (i < 0x2000000000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35 & 0x7FL | 0x80L));
            out.write((int)(i >>> 42));
            return 7;
        }
        if (i < 0x100000000000000L) {
            out.write((int)(i & 0x7FL | 0x80L));
            out.write((int)(i >>> 7 & 0x7FL | 0x80L));
            out.write((int)(i >>> 14 & 0x7FL | 0x80L));
            out.write((int)(i >>> 21 & 0x7FL | 0x80L));
            out.write((int)(i >>> 28 & 0x7FL | 0x80L));
            out.write((int)(i >>> 35 & 0x7FL | 0x80L));
            out.write((int)(i >>> 42 & 0x7FL | 0x80L));
            out.write((int)(i >>> 49));
            return 8;
        }
        out.write((int)(i & 0x7FL | 0x80L));
        out.write((int)(i >>> 7 & 0x7FL | 0x80L));
        out.write((int)(i >>> 14 & 0x7FL | 0x80L));
        out.write((int)(i >>> 21 & 0x7FL | 0x80L));
        out.write((int)(i >>> 28 & 0x7FL | 0x80L));
        out.write((int)(i >>> 35 & 0x7FL | 0x80L));
        out.write((int)(i >>> 42 & 0x7FL | 0x80L));
        out.write((int)(i >>> 49 & 0x7FL | 0x80L));
        out.write((int)(i >>> 56));
        return 9;
    }

    public static long readVInt64(DataInput in) throws IOException {
        byte b = in.readByte();
        long i = b & 0x7F;
        long shift = 7L;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
        }
        return i;
    }

    public static int writeSVInt64(DataOutput out, long i) throws IOException {
        return VIntUtils.writeVInt64(out, i << 1 ^ i >> 63);
    }

    public static long readSVInt64(DataInput in) throws IOException {
        long i = VIntUtils.readVInt64(in);
        return i >>> 1 ^ -(i & 1L);
    }

    public static int getVInt64Length(long l) {
        int ret = 0;
        do {
            ++ret;
        } while ((l >>>= 7) > 0L);
        return ret;
    }
}

