/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import com.google.common.io.Closer;
import com.google.common.io.LittleEndianDataOutputStream;
import com.indeed.util.io.SyncableDataOutput;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public final class BufferedFileDataOutputStream
extends OutputStream
implements SyncableDataOutput {
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final ByteBuffer buffer;
    private final FileChannel channel;
    private final DataOutput dataOut;
    private final Closer closer = Closer.create();

    public BufferedFileDataOutputStream(File file) throws FileNotFoundException {
        this(file, ByteOrder.BIG_ENDIAN);
    }

    public BufferedFileDataOutputStream(File file, ByteOrder order) throws FileNotFoundException {
        this(file, order, 131072);
    }

    public BufferedFileDataOutputStream(File file, ByteOrder order, int bufferSize) throws FileNotFoundException {
        RandomAccessFile raf = (RandomAccessFile)this.closer.register((Closeable)new RandomAccessFile(file, "rw"));
        this.channel = raf.getChannel();
        this.closer.register((Closeable)this.channel);
        this.buffer = ByteBuffer.allocate(bufferSize);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            this.dataOut = new LittleEndianDataOutputStream((OutputStream)this);
        } else if (order == ByteOrder.BIG_ENDIAN) {
            this.dataOut = new DataOutputStream(this);
        } else {
            throw new IllegalArgumentException(order + " is not ByteOrder.BIG_ENDIAN or ByteOrder.LITTLE_ENDIAN");
        }
    }

    public BufferedFileDataOutputStream(Path path) throws IOException {
        this(path, ByteOrder.BIG_ENDIAN);
    }

    public BufferedFileDataOutputStream(Path path, ByteOrder order) throws IOException {
        this(path, order, 131072);
    }

    public BufferedFileDataOutputStream(Path path, ByteOrder order, int bufferSize) throws IOException {
        this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.closer.register((Closeable)this.channel);
        this.buffer = ByteBuffer.allocate(bufferSize);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            this.dataOut = new LittleEndianDataOutputStream((OutputStream)this);
        } else if (order == ByteOrder.BIG_ENDIAN) {
            this.dataOut = new DataOutputStream(this);
        } else {
            throw new IllegalArgumentException(order + " is not ByteOrder.BIG_ENDIAN or ByteOrder.LITTLE_ENDIAN");
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer.remaining() == 0) {
            this.flush();
        }
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int current = off;
        int end = off + len;
        while (current < end) {
            int size = Math.min(this.buffer.remaining(), end - current);
            if (size == 0) {
                this.flush();
                continue;
            }
            this.buffer.put(b, current, size);
            current += size;
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataOut.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataOut.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dataOut.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dataOut.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dataOut.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dataOut.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dataOut.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dataOut.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataOut.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dataOut.writeChars(s);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.dataOut.writeUTF(str);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closer.close();
    }

    @Override
    public long position() throws IOException {
        return this.channel.position() + (long)this.buffer.position();
    }

    @Override
    public void sync() throws IOException {
        this.flush();
        this.channel.force(true);
    }
}

