/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import com.google.common.io.LittleEndianDataInputStream;
import com.indeed.util.io.Seekable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public final class BufferedFileDataInputStream
extends InputStream
implements DataInput,
Seekable {
    private static final Logger log = Logger.getLogger(BufferedFileDataInputStream.class);
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final ByteBuffer buffer;
    private long bufferPos;
    private final DataInput dataInput;

    public BufferedFileDataInputStream(File file) throws FileNotFoundException {
        this(file, ByteOrder.BIG_ENDIAN);
    }

    public BufferedFileDataInputStream(File file, ByteOrder order) throws FileNotFoundException {
        this(file, order, 131072);
    }

    public BufferedFileDataInputStream(File file, ByteOrder order, int bufferSize) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, "r");
        this.channel = this.raf.getChannel();
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
        this.dataInput = order == ByteOrder.BIG_ENDIAN ? new DataInputStream(this) : new LittleEndianDataInputStream((InputStream)this);
    }

    private boolean fillBuffer() throws IOException {
        this.buffer.position(0);
        int limit = (int)Math.min(this.channel.size() - this.channel.position(), (long)this.buffer.capacity());
        this.buffer.limit(limit);
        if (limit == 0) {
            return false;
        }
        this.bufferPos = this.channel.position();
        this.channel.read(this.buffer);
        this.buffer.flip();
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.remaining() == 0 && !this.fillBuffer()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.remaining() == 0 && !this.fillBuffer()) {
            return -1;
        }
        int read = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, read);
        return read;
    }

    @Override
    public long position() throws IOException {
        return this.bufferPos + (long)this.buffer.position();
    }

    @Override
    public long length() throws IOException {
        return this.channel.size();
    }

    @Override
    public void seek(long addr) throws IOException {
        if (addr >= this.bufferPos && addr <= this.bufferPos + (long)this.buffer.limit()) {
            this.buffer.position((int)(addr - this.bufferPos));
        } else {
            this.channel.position(addr);
            this.bufferPos = addr;
            this.buffer.position(0);
            this.buffer.limit(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.raf.close();
    }

    @Override
    public String readUTF() throws IOException {
        return this.dataInput.readUTF();
    }

    @Override
    public String readLine() throws IOException {
        return this.dataInput.readLine();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dataInput.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.dataInput.readFloat();
    }

    @Override
    public long readLong() throws IOException {
        return this.dataInput.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return this.dataInput.readInt();
    }

    @Override
    public char readChar() throws IOException {
        return this.dataInput.readChar();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.dataInput.readUnsignedShort();
    }

    @Override
    public short readShort() throws IOException {
        return this.dataInput.readShort();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dataInput.readBoolean();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.dataInput.skipBytes(n);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataInput.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.dataInput.readFully(b);
    }

    @Override
    public byte readByte() throws IOException {
        return this.dataInput.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.dataInput.readUnsignedByte();
    }
}

