/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.base.Strings;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeLibraryUtils {
    private static final Logger log = LoggerFactory.getLogger(NativeLibraryUtils.class);

    public static void loadLibrary(String name) {
        NativeLibraryUtils.loadLibrary(name, "");
    }

    public static void loadLibrary(String name, String version) {
        try {
            String osName = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            String prefix = NativeLibraryUtils.getLibraryPrefix(osName);
            String extension = NativeLibraryUtils.getLibraryType(osName);
            String libName = prefix + name + "." + extension + (Strings.isNullOrEmpty((String)version) ? "" : "." + version);
            if (NativeLibraryUtils.tryLoad("/native/" + osName + "-" + arch + "/" + libName, prefix, name, extension)) {
                return;
            }
            if ("Mac OS X".equals(osName) && NativeLibraryUtils.tryLoad("/native/" + osName + "/" + libName, prefix, name, extension)) {
                return;
            }
        }
        catch (Exception | UnsatisfiedLinkError e) {
            log.warn("unable to load {} using class loader, looking in java.library.path", (Object)name, (Object)e);
        }
        System.loadLibrary(name);
    }

    /*
     * Exception decompiling
     */
    private static boolean tryLoad(String resourcePath, String prefix, String name, String extension) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String getLibraryPrefix(String os) {
        if (os.startsWith("Windows")) {
            return "";
        }
        return "lib";
    }

    static String getLibraryType(String os) {
        if (os.startsWith("Linux")) {
            return "so";
        }
        if (os.startsWith("FreeBSD")) {
            return "so";
        }
        if (os.startsWith("Mac OS X")) {
            return "dylib";
        }
        if (os.startsWith("Windows")) {
            return "dll";
        }
        throw new IllegalArgumentException();
    }
}

