/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.Bucket;
import com.indeed.proctor.consumer.Test;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGroups {
    private final ProctorResult proctorResult;
    private final LinkedHashMap<String, TestBucket> buckets;
    protected static final char ALLOCATION_GROUP_SEPARATOR = ':';

    protected AbstractGroups(ProctorResult proctorResult) {
        this.proctorResult = proctorResult;
        this.buckets = Maps.newLinkedHashMap();
        for (Map.Entry entry : proctorResult.getBuckets().entrySet()) {
            TestBucket testBucket = (TestBucket)entry.getValue();
            this.buckets.put((String)entry.getKey(), testBucket);
        }
    }

    protected boolean isBucketActive(String testName, int value) {
        return Optional.ofNullable(this.buckets.get(testName)).filter(testBucket -> value == testBucket.getValue()).isPresent();
    }

    protected boolean isBucketActive(String testName, int value, int defaultValue) {
        int bucketValueOrDefault = Optional.ofNullable(this.buckets.get(testName)).map(TestBucket::getValue).orElse(defaultValue);
        return bucketValueOrDefault == value;
    }

    protected int getValue(String testName, int defaultValue) {
        return Optional.ofNullable(this.buckets.get(testName)).map(TestBucket::getValue).orElse(defaultValue);
    }

    public Map<String, String> getTestVersions() {
        return this.proctorResult.getTestVersions();
    }

    public Map<String, String> getTestVersions(Set<String> tests) {
        LinkedHashMap selectedTestVersions = Maps.newLinkedHashMap();
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        for (String testName : tests) {
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            if (testDefinition == null) continue;
            selectedTestVersions.put(testName, testDefinition.getVersion());
        }
        return selectedTestVersions;
    }

    @Deprecated
    @Nonnull
    protected Payload getPayload(String testName) {
        return Optional.ofNullable(this.buckets.get(testName)).map(TestBucket::getPayload).orElse(Payload.EMPTY_PAYLOAD);
    }

    @Nonnull
    protected Payload getPayload(String testName, @Nonnull Bucket<?> fallbackBucket) {
        Optional<TestBucket> testBucket = Optional.ofNullable(this.buckets.get(testName));
        Optional<Payload> payload = testBucket.isPresent() ? testBucket.map(TestBucket::getPayload) : Optional.ofNullable(this.getTestBucketForBucket(testName, fallbackBucket)).map(TestBucket::getPayload);
        return payload.orElse(Payload.EMPTY_PAYLOAD);
    }

    @Nullable
    protected TestBucket getTestBucketForBucket(String testName, Bucket<?> targetBucket) {
        return Optional.ofNullable(this.proctorResult.getTestDefinitions()).map(testDefinitions -> (ConsumableTestDefinition)testDefinitions.get(testName)).map(ConsumableTestDefinition::getBuckets).map(buckets -> buckets.stream().filter(testBucket -> targetBucket.getValue() == testBucket.getValue()).findFirst().orElse(null)).orElse(null);
    }

    public String toLongString() {
        if (this.proctorResult.getBuckets().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.proctorResult.getBuckets().size() * 10);
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            sb.append(testName).append('-').append(testBucket.getName()).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    @Deprecated
    public String toString() {
        return this.toLoggingString();
    }

    public String toLoggingString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = this.buildTestGroupString();
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public StringBuilder buildTestGroupString() {
        StringBuilder sb = new StringBuilder(this.proctorResult.getBuckets().size() * 10);
        this.appendTestGroups(sb);
        return sb;
    }

    public void appendTestGroups(StringBuilder sb) {
        this.appendTestGroups(sb, ',');
    }

    protected boolean isEmpty() {
        return this.proctorResult.getBuckets().isEmpty();
    }

    public void appendTestGroups(StringBuilder sb, char separator) {
        List<String> testNames = this.getLoggingTestNames();
        this.appendTestGroupsWithoutAllocations(sb, separator, testNames);
        this.appendTestGroupsWithAllocations(sb, separator, testNames);
    }

    protected final List<String> getLoggingTestNames() {
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            if (testDefinition != null && testDefinition.getSilent() || testBucket.getValue() < 0) continue;
            builder.add((Object)testName);
        }
        return builder.build();
    }

    protected final void appendTestGroupsWithoutAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            TestBucket testBucket = (TestBucket)this.proctorResult.getBuckets().get(testName);
            if (testBucket == null) continue;
            sb.append(testName).append(testBucket.getValue()).append(separator);
        }
    }

    protected final void appendTestGroupsWithAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            TestBucket testBucket = (TestBucket)this.proctorResult.getBuckets().get(testName);
            Allocation allocation = (Allocation)this.proctorResult.getAllocations().get(testName);
            if (testBucket == null || allocation == null || Strings.isNullOrEmpty((String)allocation.getId())) continue;
            sb.append(allocation.getId()).append(':').append(testName).append(testBucket.getValue()).append(separator);
        }
    }

    public Map<String, Integer> getJavaScriptConfig() {
        return this.proctorResult.getBuckets().entrySet().stream().filter(e -> ((TestBucket)e.getValue()).getValue() >= 0).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TestBucket)e.getValue()).getValue()));
    }

    public <E extends Test> List<List<Object>> getJavaScriptConfig(E[] tests) {
        return Arrays.stream(tests).map(test -> Arrays.asList(this.getValue(test.getName(), test.getFallbackValue()), this.getPayload(test.getName()).fetchAValue())).collect(Collectors.toList());
    }

    public ProctorResult getProctorResult() {
        return this.proctorResult;
    }
}

