/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.indeed.proctor.common.model.Payload;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGroupsPayload {
    private static final Function<Object, Long> LONG_CONVERTER = o -> AbstractGroupsPayload.convertToNumber(o).longValue();
    private static final Function<Object, Double> DOUBLE_CONVERTER = o -> AbstractGroupsPayload.convertToNumber(o).doubleValue();
    public static final Function<Object, String> STRING_CONVERTER = o -> {
        if (o == null || o instanceof String) {
            return (String)o;
        }
        throw new ClassCastException("Cannot convert '" + o + "' to String");
    };

    @Nullable
    protected String convertToStringValue(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        return AbstractGroupsPayload.extractValueFromMapPayload(payload, payloadMapKey, STRING_CONVERTER).orElse(null);
    }

    protected Long convertToLongValue(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        return AbstractGroupsPayload.extractNonNullValueFromMapPayload(payload, payloadMapKey, LONG_CONVERTER);
    }

    protected Double convertToDoubleValue(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        return AbstractGroupsPayload.extractNonNullValueFromMapPayload(payload, payloadMapKey, DOUBLE_CONVERTER);
    }

    protected String[] convertToStringArray(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        return (String[])AbstractGroupsPayload.extractNonNullValueFromMapPayload(payload, payloadMapKey, o -> AbstractGroupsPayload.convertToList(o)).stream().map(STRING_CONVERTER).toArray(String[]::new);
    }

    protected Long[] convertToLongArray(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        return (Long[])AbstractGroupsPayload.extractListWithouNullsFromMapPayload(payload, payloadMapKey, o -> AbstractGroupsPayload.convertToList(o)).stream().map(LONG_CONVERTER).toArray(Long[]::new);
    }

    protected Double[] convertToDoubleArray(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        return (Double[])AbstractGroupsPayload.extractListWithouNullsFromMapPayload(payload, payloadMapKey, o -> AbstractGroupsPayload.convertToList(o)).stream().map(DOUBLE_CONVERTER).toArray(Double[]::new);
    }

    private static <T> List<T> convertToList(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        throw new ClassCastException("Cannot convert '" + o + "' to List");
    }

    private static Number convertToNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new ClassCastException("Cannot convert '" + o + "' to Number");
    }

    @Nonnull
    private static <T> List<T> extractListWithouNullsFromMapPayload(Payload payload, String payloadMapKey, Function<Object, List<T>> converter) {
        List<T> list = AbstractGroupsPayload.extractNonNullValueFromMapPayload(payload, payloadMapKey, converter);
        if (list.contains(null)) {
            throw new NullPointerException("Null payload list value for constructor for key '" + payloadMapKey + '\'' + " in Payload: " + payload);
        }
        return list;
    }

    @Nonnull
    private static <T> T extractNonNullValueFromMapPayload(Payload payload, String payloadMapKey, Function<Object, T> converter) {
        return AbstractGroupsPayload.extractValueFromMapPayload(payload, payloadMapKey, converter).orElseThrow(() -> new NullPointerException("Null payload value for constructor for key '" + payloadMapKey + '\'' + " in Payload: " + payload));
    }

    @Nonnull
    private static <T> Optional<T> extractValueFromMapPayload(Payload payload, String payloadMapKey, Function<Object, T> converter) {
        Optional<Map> payloadMapOpt = Optional.ofNullable(payload).map(Payload::getMap);
        if (payloadMapOpt.isPresent() && payloadMapOpt.get().containsKey(payloadMapKey)) {
            return payloadMapOpt.map(m -> m.get(payloadMapKey)).map(converter);
        }
        throw new IllegalArgumentException("Missing payload for constructor for key '" + payloadMapKey + '\'' + " in Payload: " + payload);
    }
}

