/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.shaded.org.apache.el7;

import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELException;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.shaded.javax.el7.PropertyNotFoundException;
import com.indeed.shaded.javax.el7.PropertyNotWritableException;
import com.indeed.shaded.javax.el7.ValueExpression;
import com.indeed.shaded.javax.el7.ValueReference;
import com.indeed.shaded.javax.el7.VariableMapper;
import com.indeed.shaded.org.apache.el7.lang.ELSupport;
import com.indeed.shaded.org.apache.el7.lang.EvaluationContext;
import com.indeed.shaded.org.apache.el7.lang.ExpressionBuilder;
import com.indeed.shaded.org.apache.el7.parser.AstLiteralExpression;
import com.indeed.shaded.org.apache.el7.parser.Node;
import com.indeed.shaded.org.apache.el7.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class<?> expectedType) {
        this.expr = expr;
        this.node = node;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expectedType = expectedType;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ValueExpressionImpl && obj.hashCode() == this.hashCode();
    }

    @Override
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getExpressionString() {
        return this.expr;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    @Override
    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return this.getNode().getType(ctx);
    }

    @Override
    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        Object value = this.getNode().getValue(ctx);
        if (this.expectedType != null) {
            return ELSupport.coerceToType(value, this.expectedType);
        }
        return value;
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    @Override
    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException ele) {
            return false;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return this.getNode().isReadOnly(ctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expr = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }

    @Override
    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        this.getNode().setValue(ctx, value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expr);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    public String toString() {
        return "ValueExpression[" + this.expr + "]";
    }

    @Override
    public ValueReference getValueReference(ELContext context) {
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return this.getNode().getValueReference(ctx);
    }
}

