/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestDefinition;
import com.indeed.proctor.common.model.TestDependency;
import com.indeed.proctor.common.model.TestType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ConsumableTestDefinition {
    @Nonnull
    private Map<String, Object> constants = Collections.emptyMap();
    private String version;
    @Nullable
    private String salt;
    @Nullable
    private String rule;
    @Nonnull
    private List<TestBucket> buckets = Collections.emptyList();
    @Nonnull
    private List<Allocation> allocations = Collections.emptyList();
    private boolean silent = false;
    @Nonnull
    private TestType testType;
    @Nullable
    private String description;
    @Nonnull
    private List<String> metaTags = Collections.emptyList();
    @Nullable
    private TestDependency dependsOn;
    private boolean isDynamic = false;
    private boolean hasLogged = false;

    public ConsumableTestDefinition() {
    }

    @Deprecated
    public ConsumableTestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nullable String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, @Nonnull Map<String, Object> constants, @Nullable String description) {
        this(version, rule, testType, salt, buckets, allocations, false, constants, description, Collections.emptyList());
    }

    @Deprecated
    public ConsumableTestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nullable String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nullable String description) {
        this(version, rule, testType, salt, buckets, allocations, silent, constants, description, Collections.emptyList());
    }

    @Deprecated
    public ConsumableTestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nullable String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nullable String description, @Nonnull List<String> metaTags) {
        this.constants = constants;
        this.version = version;
        this.salt = salt;
        this.rule = rule;
        this.buckets = buckets;
        this.allocations = allocations;
        this.silent = silent;
        this.testType = testType;
        this.description = description;
        this.metaTags = metaTags;
    }

    private ConsumableTestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nullable String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nullable String description, @Nonnull List<String> metaTags, @Nullable TestDependency dependsOn) {
        this.constants = constants;
        this.version = version;
        this.salt = salt;
        this.rule = rule;
        this.buckets = buckets;
        this.allocations = allocations;
        this.silent = silent;
        this.testType = testType;
        this.description = description;
        this.metaTags = metaTags;
        this.dependsOn = dependsOn;
    }

    @Nonnull
    public Map<String, Object> getConstants() {
        return this.constants;
    }

    public void setConstants(@Nonnull Map<String, Object> constants) {
        this.constants = constants;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nullable
    public String getRule() {
        return this.rule;
    }

    public void setRule(@Nullable String rule) {
        this.rule = rule;
    }

    @Nullable
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(@Nullable String salt) {
        this.salt = salt;
    }

    @Nonnull
    public List<TestBucket> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(@Nonnull List<TestBucket> buckets) {
        this.buckets = buckets;
    }

    @Nonnull
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    public void setAllocations(@Nonnull List<Allocation> allocations) {
        this.allocations = allocations;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public boolean getDynamic() {
        return this.isDynamic;
    }

    public void setHasLogged(boolean hasLogged) {
        this.hasLogged = hasLogged;
    }

    public boolean getHasLogged() {
        return this.hasLogged;
    }

    @Nonnull
    public TestType getTestType() {
        return this.testType;
    }

    public void setTestType(@Nonnull TestType testType) {
        this.testType = testType;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nonnull
    public List<String> getMetaTags() {
        return this.metaTags;
    }

    public void setMetaTags(List<String> metaTags) {
        this.metaTags = metaTags;
    }

    @Nullable
    public TestDependency getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(@Nullable TestDependency dependsOn) {
        this.dependsOn = dependsOn;
    }

    @Nonnull
    public static ConsumableTestDefinition fromTestDefinition(@Nonnull TestDefinition td) {
        String rawRule;
        Map<String, Object> specialConstants = td.getSpecialConstants();
        ArrayList ruleComponents = Lists.newArrayList();
        List countries = (List)specialConstants.get("__COUNTRIES");
        if (countries != null) {
            ruleComponents.add("proctor:contains(__COUNTRIES, country)");
        }
        if (!StringUtils.isBlank((CharSequence)(rawRule = ProctorUtils.removeElExpressionBraces(td.getRule())))) {
            ruleComponents.add(rawRule);
        }
        String rule = ruleComponents.isEmpty() ? null : "${" + String.join((CharSequence)" && ", ruleComponents) + '}';
        List<Allocation> allocations = td.getAllocations();
        for (Allocation alloc : allocations) {
            String rawAllocRule = ProctorUtils.removeElExpressionBraces(alloc.getRule());
            if (StringUtils.isBlank((CharSequence)rawAllocRule)) {
                alloc.setRule(null);
                continue;
            }
            if (rawAllocRule.startsWith("${") && rawAllocRule.endsWith("}")) continue;
            String newAllocRule = "${" + rawAllocRule + "}";
            alloc.setRule(newAllocRule);
        }
        LinkedHashMap constants = Maps.newLinkedHashMap();
        constants.putAll(td.getConstants());
        constants.putAll(specialConstants);
        return new ConsumableTestDefinition(td.getVersion(), rule, td.getTestType(), td.getSalt(), td.getBuckets(), allocations, td.getSilent(), constants, td.getDescription(), td.getMetaTags(), td.getDependsOn());
    }
}

