/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;

public class Range {
    private int bucketValue;
    private double length;

    public Range() {
    }

    public Range(int bucketValue, double length) {
        if (length < 0.0 || length > 1.0) {
            throw new IllegalArgumentException("Length must be >= 0 and <= 1");
        }
        this.bucketValue = bucketValue;
        this.length = length;
    }

    public Range(@Nonnull Range other) {
        this.bucketValue = other.bucketValue;
        this.length = other.length;
    }

    public int getBucketValue() {
        return this.bucketValue;
    }

    public void setBucketValue(int bucketValue) {
        this.bucketValue = bucketValue;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.bucketValue == range.bucketValue && Double.compare(range.length, this.length) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bucketValue, this.length});
    }

    public String toString() {
        return "Range{bucketValue=" + this.bucketValue + ", length=" + this.length + '}';
    }
}

