/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.indeed.proctor.common.model.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Allocation {
    private static final String EMPTY_STRING = "";
    @Nullable
    private String rule;
    @Nonnull
    private List<Range> ranges = Collections.emptyList();
    @Nonnull
    private String id = "";
    @Nonnull
    private String name = "";

    public Allocation() {
    }

    public Allocation(@Nullable String rule, @Nonnull List<Range> ranges) {
        this(rule, ranges, EMPTY_STRING, EMPTY_STRING);
    }

    public Allocation(@Nullable String rule, @Nonnull List<Range> ranges, @Nullable String id) {
        this(rule, ranges, id, EMPTY_STRING);
    }

    public Allocation(@Nullable String rule, @Nonnull List<Range> ranges, @Nullable String id, @Nullable String name) {
        this.rule = rule;
        this.ranges = ranges;
        this.id = Strings.nullToEmpty((String)id);
        this.name = Strings.nullToEmpty((String)name);
    }

    public Allocation(@Nonnull Allocation other) {
        this.rule = other.rule;
        this.ranges = new ArrayList<Range>();
        for (Range range : other.getRanges()) {
            this.ranges.add(new Range(range));
        }
        this.id = other.id;
        this.name = other.name;
    }

    @Nullable
    public String getRule() {
        return this.rule;
    }

    public void setRule(@Nullable String rule) {
        this.rule = rule;
    }

    @Nonnull
    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(@Nonnull List<Range> ranges) {
        this.ranges = ranges;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = Strings.nullToEmpty((String)id);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = Strings.nullToEmpty((String)name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Allocation that = (Allocation)o;
        return Objects.equal((Object)this.rule, (Object)that.rule) && Objects.equal(this.ranges, that.ranges) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rule, this.ranges, this.id, this.name});
    }

    public String toString() {
        return "Allocation{rule='" + this.rule + '\'' + ", ranges=" + this.ranges + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

