/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.el;

import com.google.common.collect.Maps;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LibraryFunctionMapper
extends FunctionMapper {
    @Nonnull
    private final Map<String, Map<String, Method>> libraries = Maps.newHashMap();
    private static final int PUBLIC_AND_STATIC = 9;

    public LibraryFunctionMapper(@Nonnull Map<String, Class<?>> libraryClasses) {
        for (Map.Entry<String, Class<?>> entry : libraryClasses.entrySet()) {
            String namespace = entry.getKey();
            Map<String, Method> functions = this.extractFunctions(entry.getValue());
            this.libraries.put(namespace, functions);
        }
    }

    private Map<String, Method> extractFunctions(@Nonnull Class<?> c) {
        HashMap libraryFunctions = Maps.newHashMap();
        for (Method m : c.getMethods()) {
            int modifiers = m.getModifiers();
            if ((modifiers & 9) == 0) continue;
            libraryFunctions.put(m.getName(), m);
        }
        return libraryFunctions;
    }

    @Override
    @Nullable
    public Method resolveFunction(@Nonnull String namespace, @Nonnull String functionName) {
        Map<String, Method> library = this.libraries.get(namespace);
        if (library == null) {
            return null;
        }
        return library.get(functionName);
    }
}

