/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.dynamic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.indeed.proctor.common.dynamic.DynamicFilter;
import com.indeed.proctor.common.dynamic.MetaTagsFilter;
import com.indeed.proctor.common.dynamic.TestNamePatternFilter;
import com.indeed.proctor.common.dynamic.TestNamePrefixFilter;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DynamicFilters
implements JsonSerializable {
    private static final List<Class<? extends DynamicFilter>> FILTER_TYPES = Collections.synchronizedList(Lists.newArrayList((Object[])new Class[]{TestNamePrefixFilter.class, TestNamePatternFilter.class, MetaTagsFilter.class}));
    private final List<DynamicFilter> filters;

    public DynamicFilters() {
        this.filters = Collections.emptyList();
    }

    @JsonCreator
    public DynamicFilters(Collection<? extends DynamicFilter> filters) {
        this.filters = ImmutableList.copyOf(filters);
    }

    @SafeVarargs
    public static void registerFilterTypes(Class<? extends DynamicFilter> ... types) {
        FILTER_TYPES.addAll(Arrays.asList(types));
    }

    public static Class<? extends DynamicFilter>[] getFilterTypes() {
        return FILTER_TYPES.toArray(new Class[0]);
    }

    public Set<String> determineTests(Map<String, ConsumableTestDefinition> definedTests, Set<String> requiredTests) {
        return definedTests.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> !requiredTests.contains(entry.getKey())).filter(entry -> this.matches((String)entry.getKey(), (ConsumableTestDefinition)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public final boolean matches(@Nullable String testName, ConsumableTestDefinition testDefinition) {
        return this.filters.stream().anyMatch(filter -> filter.matches(testName, testDefinition));
    }

    public Collection<DynamicFilter> asCollection() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFilters that = (DynamicFilters)o;
        return Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        JsonSerializer serializer = serializers.findValueSerializer(DynamicFilter[].class);
        serializer.serialize((Object)this.filters.toArray(), gen, serializers);
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        JsonSerializer serializer = serializers.findValueSerializer(DynamicFilter[].class);
        serializer.serializeWithType((Object)this.filters.toArray(), gen, serializers, typeSer);
    }
}

