/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.util.core.ReleaseVersion;
import java.util.Collection;

public class ProctorRuleFunctions {
    public static boolean contains(Collection c, Object element) {
        if (ProctorRuleFunctions.isIntegerNumber(element)) {
            long elementValue = ProctorRuleFunctions.toLong(element);
            for (Object x : c) {
                long value;
                if (!ProctorRuleFunctions.isIntegerNumber(x) || elementValue != (value = ProctorRuleFunctions.toLong(x))) continue;
                return true;
            }
            return false;
        }
        return c.contains(element);
    }

    private static boolean isFloatNumber(Object object) {
        return object instanceof Float || object instanceof Double;
    }

    private static boolean isIntegerNumber(Object object) {
        return object instanceof Number && !ProctorRuleFunctions.isFloatNumber(object);
    }

    private static long toLong(Object number) {
        return ((Number)number).longValue();
    }

    public static boolean matches(String value, String regex) {
        return value.matches(regex);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static ReleaseVersion version(String versionString) {
        return ReleaseVersion.fromString((String)versionString);
    }

    public static <T extends Comparable<T>> boolean inRange(T value, T closedLowerBound, T openUpperBound) {
        return value.compareTo(closedLowerBound) >= 0 && openUpperBound.compareTo(value) > 0;
    }

    public static boolean versionInRange(ReleaseVersion version, String startInclusive, String endExclusive) {
        ReleaseVersion start = ReleaseVersion.fromString((String)startInclusive);
        ReleaseVersion end = ReleaseVersion.fromString((String)endExclusive);
        if (end.getMatchPrecision() != ReleaseVersion.MatchPrecision.BUILD) {
            throw new IllegalStateException("Cannot use wildcard as open upper bound of range: " + endExclusive);
        }
        return ProctorRuleFunctions.inRange(version, start, end);
    }

    public static MaybeBool maybeAnd(MaybeBool op1, MaybeBool op2) {
        if (MaybeBool.FALSE == op1 || MaybeBool.FALSE == op2) {
            return MaybeBool.FALSE;
        }
        if (MaybeBool.TRUE == op1 && MaybeBool.TRUE == op2) {
            return MaybeBool.TRUE;
        }
        return MaybeBool.UNKNOWN;
    }

    public static MaybeBool maybeOr(MaybeBool op1, MaybeBool op2) {
        if (MaybeBool.TRUE == op1 || MaybeBool.TRUE == op2) {
            return MaybeBool.TRUE;
        }
        if (MaybeBool.FALSE == op1 && MaybeBool.FALSE == op2) {
            return MaybeBool.FALSE;
        }
        return MaybeBool.UNKNOWN;
    }

    public static MaybeBool maybeNot(MaybeBool maybeBool) {
        if (MaybeBool.TRUE == maybeBool) {
            return MaybeBool.FALSE;
        }
        if (MaybeBool.FALSE == maybeBool) {
            return MaybeBool.TRUE;
        }
        return MaybeBool.UNKNOWN;
    }

    public static MaybeBool toMaybeBool(boolean b) {
        return b ? MaybeBool.TRUE : MaybeBool.FALSE;
    }

    public static enum MaybeBool {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

