/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;

class JsonParserUtils {
    private JsonParserUtils() {
    }

    static void consumeJson(@Nonnull JsonParser jsonParser, PartialJsonConsumer consumer) throws IOException {
        Preconditions.checkState((jsonParser.currentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0);
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            Preconditions.checkState((jsonParser.currentToken() == JsonToken.FIELD_NAME ? 1 : 0) != 0);
            String key = jsonParser.currentName();
            jsonParser.nextToken();
            consumer.accept(key, jsonParser);
        }
    }

    static interface PartialJsonConsumer {
        public void accept(String var1, JsonParser var2) throws IOException;
    }
}

