/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProctorResult {
    public static final ProctorResult EMPTY = new ProctorResult("", Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptyMap(), new Identifiers(Collections.emptyMap()), Collections.emptyMap());
    private final String matrixVersion;
    @Nonnull
    private final SortedMap<String, TestBucket> buckets;
    @Nonnull
    private final SortedMap<String, Allocation> allocations;
    @Nonnull
    private final Map<String, ConsumableTestDefinition> testDefinitions;
    private final Identifiers identifiers;
    private final Map<String, Object> inputContext;
    private final HashSet<String> hasLoggedTests;

    @Deprecated
    public ProctorResult(@Nonnull int matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nullable Map<String, ConsumableTestDefinition> testDefinitions) {
        this(Integer.toString(matrixVersion), buckets, Collections.emptyMap(), testDefinitions);
    }

    @Deprecated
    public ProctorResult(@Nonnull String matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nullable Map<String, ConsumableTestDefinition> testDefinitions) {
        this(matrixVersion, buckets, Collections.emptyMap(), testDefinitions);
    }

    @Deprecated
    public ProctorResult(String matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nonnull Map<String, Allocation> allocations, @Nullable Map<String, ConsumableTestDefinition> testDefinitions) {
        this(matrixVersion, (SortedMap<String, TestBucket>)new TreeMap<String, TestBucket>(buckets), (SortedMap<String, Allocation>)new TreeMap<String, Allocation>(allocations), (Map<String, ConsumableTestDefinition>)(testDefinitions == null ? Collections.emptyMap() : new HashMap<String, ConsumableTestDefinition>(testDefinitions)));
    }

    @Deprecated
    public ProctorResult(@Nonnull String matrixVersion, @Nonnull SortedMap<String, TestBucket> buckets, @Nonnull SortedMap<String, Allocation> allocations, @Nonnull Map<String, ConsumableTestDefinition> testDefinitions) {
        this(matrixVersion, buckets, allocations, testDefinitions, new Identifiers(Collections.emptyMap()), Collections.emptyMap());
    }

    public ProctorResult(@Nonnull String matrixVersion, @Nonnull SortedMap<String, TestBucket> buckets, @Nonnull SortedMap<String, Allocation> allocations, @Nonnull Map<String, ConsumableTestDefinition> testDefinitions, @Nonnull Identifiers identifiers, @Nonnull Map<String, Object> inputContext) {
        this.matrixVersion = matrixVersion;
        this.buckets = buckets;
        this.allocations = allocations;
        this.testDefinitions = testDefinitions;
        this.identifiers = identifiers;
        this.inputContext = inputContext;
        this.hasLoggedTests = new HashSet();
    }

    public static ProctorResult unmodifiableView(ProctorResult proctorResult) {
        return new ProctorResult(proctorResult.matrixVersion, Collections.unmodifiableSortedMap(proctorResult.buckets), Collections.unmodifiableSortedMap(proctorResult.allocations), Collections.unmodifiableMap(proctorResult.testDefinitions), proctorResult.identifiers, Collections.unmodifiableMap(proctorResult.inputContext));
    }

    public String getMatrixVersion() {
        return this.matrixVersion;
    }

    @Nonnull
    public Map<String, TestBucket> getBuckets() {
        return this.buckets;
    }

    @Nonnull
    public Map<String, Allocation> getAllocations() {
        return this.allocations;
    }

    @Nonnull
    public Map<String, ConsumableTestDefinition> getTestDefinitions() {
        return this.testDefinitions;
    }

    @Nonnull
    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    @Nonnull
    public Map<String, Object> getInputContext() {
        return this.inputContext;
    }

    public boolean markTestAsLogged(String test) {
        return this.hasLoggedTests.add(test);
    }
}

