/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.ImmutableMap;
import com.indeed.proctor.common.model.TestType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Identifiers {
    @Nonnull
    private final Map<TestType, String> identifierMap;
    private final boolean randomEnabled;

    public Identifiers(@Nonnull Map<TestType, String> identifierMap) {
        this(identifierMap, false);
    }

    public Identifiers(@Nonnull Map<TestType, String> identifierMap, boolean randomEnabled) {
        if (identifierMap.containsKey(TestType.RANDOM)) {
            throw new IllegalArgumentException("Cannot specify " + TestType.RANDOM + " in identifierMap");
        }
        this.identifierMap = identifierMap;
        this.randomEnabled = randomEnabled;
    }

    public Identifiers(TestType type, String identifier) {
        this(Collections.singletonMap(type, identifier));
    }

    public static Identifiers of(TestType type, String identifier) {
        return new Identifiers(type, identifier);
    }

    public static Identifiers of(TestType typeA, String identifierA, TestType typeB, String identifierB) {
        return new Identifiers((Map<TestType, String>)ImmutableMap.of((Object)typeA, (Object)identifierA, (Object)typeB, (Object)identifierB));
    }

    public static Identifiers of(TestType typeA, String identifierA, TestType typeB, String identifierB, TestType typeC, String identifierC) {
        return new Identifiers((Map<TestType, String>)ImmutableMap.of((Object)typeA, (Object)identifierA, (Object)typeB, (Object)identifierB, (Object)typeC, (Object)identifierC));
    }

    public boolean isRandomEnabled() {
        return this.randomEnabled;
    }

    public Set<TestType> getAvailableTestTypes() {
        return this.identifierMap.keySet();
    }

    @CheckForNull
    public String getIdentifier(TestType testType) {
        return this.identifierMap.get(testType);
    }

    @CheckForNull
    public String getUserId() {
        return this.getIdentifier(TestType.USER);
    }

    @CheckForNull
    public String getPageId() {
        return this.getIdentifier(TestType.PAGE);
    }

    @CheckForNull
    public String getCompanyId() {
        return this.getIdentifier(TestType.COMPANY);
    }

    @CheckForNull
    public String getEmail() {
        return this.getIdentifier(TestType.EMAIL);
    }

    @CheckForNull
    public String getAccountId() {
        return this.getIdentifier(TestType.ACCOUNT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifiers that = (Identifiers)o;
        return this.randomEnabled == that.randomEnabled && Objects.equals(this.identifierMap, that.identifierMap);
    }

    public int hashCode() {
        return Objects.hash(this.identifierMap, this.randomEnabled);
    }
}

