/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestDefinition {
    private String version;
    @Nonnull
    private Map<String, Object> constants = Collections.emptyMap();
    @Nonnull
    private Map<String, Object> specialConstants = Collections.emptyMap();
    @Nonnull
    private String salt;
    @Nullable
    private String rule;
    @Nonnull
    private List<TestBucket> buckets = Collections.emptyList();
    @Nonnull
    private List<Allocation> allocations = Collections.emptyList();
    private boolean silent;
    @Nonnull
    private List<String> metaTags = Collections.emptyList();
    @Nonnull
    private TestType testType;
    @Nullable
    private String description;

    public TestDefinition() {
    }

    @Deprecated
    public TestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nonnull String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, @Nonnull Map<String, Object> constants, @Nonnull Map<String, Object> specialConstants, @Nullable String description) {
        this(version, rule, testType, salt, buckets, allocations, false, constants, specialConstants, description, Collections.emptyList());
    }

    @Deprecated
    public TestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nonnull String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nonnull Map<String, Object> specialConstants, @Nullable String description) {
        this(version, rule, testType, salt, buckets, allocations, silent, constants, specialConstants, description, Collections.emptyList());
    }

    public TestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nonnull String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nonnull Map<String, Object> specialConstants, @Nullable String description, @Nonnull List<String> metaTags) {
        this.version = version;
        this.constants = constants;
        this.specialConstants = specialConstants;
        this.salt = salt;
        this.rule = rule;
        this.buckets = buckets;
        this.allocations = allocations;
        this.silent = silent;
        this.testType = testType;
        this.description = description;
        this.metaTags = metaTags;
    }

    public TestDefinition(@Nonnull TestDefinition other) {
        this.version = other.version;
        this.salt = other.salt;
        this.rule = other.rule;
        this.silent = other.silent;
        this.description = other.description;
        if (other.constants != null) {
            this.constants = Maps.newHashMap(other.constants);
        }
        if (other.specialConstants != null) {
            this.specialConstants = Maps.newHashMap(other.specialConstants);
        }
        if (other.buckets != null) {
            this.buckets = new ArrayList<TestBucket>();
            for (TestBucket bucket : other.buckets) {
                this.buckets.add(new TestBucket(bucket));
            }
        }
        if (other.allocations != null) {
            this.allocations = new ArrayList<Allocation>();
            for (Allocation allocation : other.allocations) {
                this.allocations.add(new Allocation(allocation));
            }
        }
        this.metaTags = other.metaTags != null ? new ArrayList<String>(other.metaTags) : Collections.emptyList();
        this.testType = other.testType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nonnull
    public Map<String, Object> getConstants() {
        return this.constants;
    }

    public void setConstants(@Nonnull Map<String, Object> constants) {
        this.constants = constants;
    }

    @Nonnull
    public Map<String, Object> getSpecialConstants() {
        return this.specialConstants;
    }

    public void setSpecialConstants(@Nonnull Map<String, Object> specialConstants) {
        this.specialConstants = specialConstants;
    }

    @Nullable
    public String getRule() {
        return this.rule;
    }

    @Deprecated
    public void setSubrule(@Nullable String subrule) {
        this.setRule(subrule);
    }

    public void setRule(@Nullable String rule) {
        this.rule = rule;
    }

    @Nonnull
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(@Nonnull String salt) {
        this.salt = salt;
    }

    @Nonnull
    public List<TestBucket> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(@Nonnull List<TestBucket> buckets) {
        this.buckets = buckets;
    }

    @Nonnull
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    public void setAllocations(@Nonnull List<Allocation> allocations) {
        this.allocations = allocations;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Nonnull
    public TestType getTestType() {
        return this.testType;
    }

    public void setTestType(TestType testType) {
        this.testType = testType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public List<String> getMetaTags() {
        return this.metaTags;
    }

    public void setMetaTags(List<String> metaTags) {
        this.metaTags = metaTags;
    }

    public String toString() {
        return "TestDefinition{version='" + this.version + '\'' + ", constants=" + this.constants + ", specialConstants=" + this.specialConstants + ", salt='" + this.salt + '\'' + ", rule='" + this.rule + '\'' + ", buckets=" + this.buckets + ", allocations=" + this.allocations + ", silent=" + this.silent + ", testType=" + this.testType + ", description='" + this.description + '\'' + ", metaTags=" + this.metaTags + '}';
    }

    public int hashCode() {
        ArrayList<1> bucketWrappers = new ArrayList<1>();
        if (this.buckets != null) {
            for (final TestBucket bucket : this.buckets) {
                bucketWrappers.add(new Object(){

                    public int hashCode() {
                        return bucket.fullHashCode();
                    }
                });
            }
        }
        return Objects.hashCode((Object[])new Object[]{this.version, this.constants, this.specialConstants, this.salt, this.rule, bucketWrappers, this.allocations, this.silent, this.testType, this.description, this.metaTags});
    }

    public boolean equals(Object otherDefinition) {
        if (this == otherDefinition) {
            return true;
        }
        if (otherDefinition == null || this.getClass() != otherDefinition.getClass()) {
            return false;
        }
        TestDefinition that = (TestDefinition)otherDefinition;
        return this.silent == that.silent && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal(this.constants, that.constants) && Objects.equal(this.specialConstants, that.specialConstants) && Objects.equal((Object)this.salt, (Object)that.salt) && Objects.equal((Object)this.rule, (Object)that.rule) && TestDefinition.bucketListEqual(this.buckets, that.buckets) && Objects.equal(this.allocations, that.allocations) && Objects.equal((Object)this.testType, (Object)that.testType) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.metaTags, that.metaTags);
    }

    @VisibleForTesting
    static boolean bucketListEqual(List<TestBucket> bucketsA, List<TestBucket> bucketsB) {
        if (bucketsA == bucketsB) {
            return true;
        }
        if (!Objects.equal(bucketsA, bucketsB)) {
            return false;
        }
        Iterator<TestBucket> itA = bucketsA.iterator();
        Iterator<TestBucket> itB = bucketsB.iterator();
        while (itA.hasNext() && itB.hasNext()) {
            TestBucket bucketA = itA.next();
            TestBucket bucketB = itB.next();
            if (bucketA == null || bucketA.fullEquals(bucketB)) continue;
            return false;
        }
        return true;
    }
}

