/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.TestChooser;
import com.indeed.proctor.common.TestRangeSelector;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Range;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.shaded.javax.el7.ExpressionFactory;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@VisibleForTesting
class StandardTestChooser
implements TestChooser<String> {
    @Nonnull
    private final TestRangeSelector testRangeSelector;
    @Nonnull
    private final Hasher hasher;
    @Nonnull
    private final int[][] cutoffs;

    public StandardTestChooser(@Nonnull ExpressionFactory expressionFactory, @Nonnull FunctionMapper functionMapper, @Nonnull String testName, @Nonnull ConsumableTestDefinition testDefinition) {
        this(new TestRangeSelector(expressionFactory, functionMapper, testName, testDefinition));
    }

    @VisibleForTesting
    StandardTestChooser(@Nonnull TestRangeSelector selector) {
        this.testRangeSelector = selector;
        this.hasher = StandardTestChooser.newHasherFor(selector);
        ConsumableTestDefinition testDefinition = selector.getTestDefinition();
        HashMap bucketValueToTest = Maps.newHashMap();
        for (TestBucket testBucket : testDefinition.getBuckets()) {
            bucketValueToTest.put(testBucket.getValue(), testBucket);
        }
        List<Allocation> allocations = testDefinition.getAllocations();
        this.cutoffs = new int[allocations.size()][];
        for (int i = 0; i < allocations.size(); ++i) {
            Allocation allocation = allocations.get(i);
            List<Range> ranges = allocation.getRanges();
            this.cutoffs[i] = StandardTestChooser.constructCutoffArray(allocation.getRule(), ranges);
        }
    }

    @Nonnull
    private static int[] constructCutoffArray(@Nullable String rule, @Nonnull List<Range> ranges) {
        int[] cutoffs = new int[ranges.size() - 1];
        double bucketTotal = 0.0;
        for (int i = 0; i < ranges.size(); ++i) {
            bucketTotal += ranges.get(i).getLength();
            if (i >= cutoffs.length) continue;
            cutoffs[i] = (int)(-2.147483648E9 + bucketTotal * 4.294967295E9);
        }
        if (bucketTotal < 0.9999 || bucketTotal > 1.0001) {
            throw new IllegalArgumentException("Buckets with rule " + rule + " don't add up to 1: " + ranges.stream().map(r -> Double.toString(r.getLength())).collect(Collectors.joining(" + ")) + " = " + bucketTotal);
        }
        return cutoffs;
    }

    public static Hasher newHasherFor(@Nonnull TestRangeSelector selector) {
        String salt = Strings.nullToEmpty((String)selector.getTestDefinition().getSalt());
        AbstractMD5Hasher result = salt.startsWith("&") ? new TestSaltHasher(selector) : new TestNameAndSaltHasher(selector);
        return result;
    }

    @Override
    @Nonnull
    public TestChooser.Result choose(@Nullable String identifier, @Nonnull Map<String, Object> values) {
        int matchingRuleIndex = this.testRangeSelector.findMatchingRule(values);
        if (matchingRuleIndex < 0) {
            return TestChooser.Result.EMPTY;
        }
        Allocation matchingAllocation = this.testRangeSelector.getTestDefinition().getAllocations().get(matchingRuleIndex);
        return new TestChooser.Result(this.chooseBucket(this.cutoffs[matchingRuleIndex], this.testRangeSelector.getBucketRange(matchingRuleIndex), (String)Preconditions.checkNotNull((Object)identifier, (Object)"Missing identifier")), matchingAllocation);
    }

    private TestBucket chooseBucket(@Nonnull int[] matchingCutoffs, TestBucket[] matchingBucketRange, @Nonnull String identifier) {
        int i;
        int value = this.hasher.hash(identifier);
        for (i = 0; i < matchingCutoffs.length && value > matchingCutoffs[i]; ++i) {
        }
        return matchingBucketRange[i];
    }

    private Map<String, String> getDescriptorParameters() {
        LinkedHashMap parameters = Maps.newLinkedHashMap();
        parameters.put("type", this.testRangeSelector.getTestDefinition().getTestType().name());
        parameters.put("salt", this.testRangeSelector.getTestDefinition().getSalt());
        return parameters;
    }

    public String toString() {
        Map<String, String> parameters = this.getDescriptorParameters();
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.testRangeSelector.printTestBuckets(writer, parameters);
        return ((Object)sw).toString();
    }

    @Override
    public void printTestBuckets(@Nonnull PrintWriter writer) {
        Map<String, String> parameters = this.getDescriptorParameters();
        this.testRangeSelector.printTestBuckets(writer, parameters);
    }

    @Override
    public TestBucket getTestBucket(int value) {
        return this.testRangeSelector.getTestBucket(value);
    }

    @Override
    @Nonnull
    public String[] getRules() {
        return this.testRangeSelector.getRules();
    }

    @Override
    @Nonnull
    public ConsumableTestDefinition getTestDefinition() {
        return this.testRangeSelector.getTestDefinition();
    }

    @Override
    @Nonnull
    public String getTestName() {
        return this.testRangeSelector.getTestName();
    }

    private static class TestSaltHasher
    extends AbstractMD5Hasher {
        private TestSaltHasher(@Nonnull TestRangeSelector selector) {
            super(TestSaltHasher.extractSalt(selector));
        }

        private static String extractSalt(@Nonnull TestRangeSelector selector) {
            ConsumableTestDefinition testDefinition = selector.getTestDefinition();
            return Strings.nullToEmpty((String)testDefinition.getSalt());
        }
    }

    private static class TestNameAndSaltHasher
    extends AbstractMD5Hasher {
        private TestNameAndSaltHasher(@Nonnull TestRangeSelector selector) {
            super(TestNameAndSaltHasher.extractSalt(selector));
        }

        private static String extractSalt(@Nonnull TestRangeSelector selector) {
            String testName = selector.getTestName();
            ConsumableTestDefinition testDefinition = selector.getTestDefinition();
            return testName + "|" + testDefinition.getSalt();
        }
    }

    private static abstract class AbstractMD5Hasher
    implements Hasher {
        private final byte[] bytes;

        public AbstractMD5Hasher(String salt) {
            this.bytes = salt.getBytes(Charsets.UTF_8);
        }

        @Override
        public int hash(@Nonnull String identifier) {
            MessageDigest md = ProctorUtils.createMessageDigest();
            md.update(this.bytes);
            md.update(identifier.getBytes(Charsets.UTF_8));
            byte[] digest = md.digest();
            return AbstractMD5Hasher.convertToInt(digest);
        }

        private static int convertToInt(byte[] digest) {
            int offset = 12;
            return (0xFF & digest[12]) << 24 | (0xFF & digest[13]) << 16 | (0xFF & digest[14]) << 8 | 0xFF & digest[15];
        }
    }

    private static interface Hasher {
        public int hash(@Nonnull String var1);
    }
}

