/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.indeed.proctor.common.model.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Allocation {
    @Nullable
    private String rule;
    @Nonnull
    private List<Range> ranges = Collections.emptyList();

    public Allocation() {
    }

    public Allocation(@Nullable String rule, @Nonnull List<Range> ranges) {
        this.rule = rule;
        this.ranges = ranges;
    }

    public Allocation(@Nonnull Allocation other) {
        this.rule = other.rule;
        this.ranges = new ArrayList<Range>();
        for (Range range : other.getRanges()) {
            this.ranges.add(new Range(range));
        }
    }

    @Nullable
    public String getRule() {
        return this.rule;
    }

    public void setRule(@Nullable String rule) {
        this.rule = rule;
    }

    @Nonnull
    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(@Nonnull List<Range> ranges) {
        this.ranges = ranges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Allocation that = (Allocation)o;
        if (this.rule != null ? !this.rule.equals(that.rule) : that.rule != null) {
            return false;
        }
        return this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        int result = this.rule != null ? this.rule.hashCode() : 0;
        result = 31 * result + this.ranges.hashCode();
        return result;
    }
}

