/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public final class TestType
implements JsonSerializable {
    private static final ConcurrentMap<String, TestType> TYPES = Maps.newConcurrentMap();
    @Nonnull
    private final String name;
    public static final TestType ANONYMOUS_USER;
    public static final TestType USER;
    public static final TestType AUTHENTICATED_USER;
    public static final TestType ACCOUNT;
    public static final TestType EMAIL_ADDRESS;
    public static final TestType EMAIL;
    public static final TestType RANDOM;
    public static final TestType PAGE;
    public static final TestType COMPANY;

    private TestType(@Nonnull String id) {
        this.name = id;
    }

    @Nonnull
    public static TestType register(@Nonnull String name) {
        TestType testType = new TestType(name);
        TestType previous = TYPES.putIfAbsent(testType.name(), testType);
        return previous != null ? previous : testType;
    }

    public String name() {
        return this.name;
    }

    public static TestType[] values() {
        Collection<TestType> allRegistered = TestType.all();
        return allRegistered.toArray(new TestType[allRegistered.size()]);
    }

    public static Collection<TestType> all() {
        return ImmutableList.copyOf(TYPES.values());
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        jsonGenerator.writeString(this.name);
    }

    public void serialize(@Nonnull JsonGenerator jsonGenerator, @Nonnull SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestType)) {
            return false;
        }
        TestType testType = (TestType)o;
        return this.name.equals(testType.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        USER = ANONYMOUS_USER = TestType.register("USER");
        ACCOUNT = AUTHENTICATED_USER = TestType.register("ACCOUNT");
        EMAIL = EMAIL_ADDRESS = TestType.register("EMAIL");
        RANDOM = TestType.register("RANDOM");
        PAGE = TestType.register("PAGE");
        COMPANY = TestType.register("COMPANY");
    }
}

