/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.indeed.proctor.common.AbstractJsonProctorLoader;
import com.indeed.proctor.common.AbstractProctorDiffReporter;
import com.indeed.proctor.common.ClasspathProctorLoader;
import com.indeed.proctor.common.FileProctorLoader;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.Serializers;
import com.indeed.util.varexport.ManagedVariable;
import com.indeed.util.varexport.VarExporter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.FunctionMapper;
import org.springframework.core.io.Resource;

public class JsonProctorLoaderFactory {
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();
    protected static final VarExporter VAR_EXPORTER = VarExporter.forNamespace((String)JsonProctorLoaderFactory.class.getSimpleName());
    @Nullable
    protected String classResourcePath;
    @Nullable
    protected String filePath;
    @Nullable
    protected ProctorSpecification _specification;
    protected FunctionMapper functionMapper = RuleEvaluator.FUNCTION_MAPPER;
    protected AbstractProctorDiffReporter diffReporter = new AbstractProctorDiffReporter();

    public void setClassResourcePath(@Nullable String classResourcePath) {
        this.classResourcePath = classResourcePath;
    }

    public void setFilePath(@Nullable String filePath) {
        this.filePath = filePath;
    }

    public void setSpecificationResource(@Nonnull Resource specificationResource) {
        try {
            this.readSpecificationResource(specificationResource.getInputStream(), specificationResource.toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read proctor specification from " + specificationResource, e);
        }
    }

    public void setSpecificationResource(@Nonnull String specificationResource) {
        try {
            if (specificationResource.startsWith("classpath:")) {
                String specificationResourceClasspath = specificationResource.replace("classpath:", "");
                InputStream is = this.getClass().getResourceAsStream(specificationResourceClasspath);
                this.readSpecificationResource(is, specificationResource);
                is.close();
            } else {
                FileInputStream fis = new FileInputStream(specificationResource);
                this.readSpecificationResource(fis, specificationResource);
                fis.close();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read proctor specification from " + specificationResource, e);
        }
    }

    private void readSpecificationResource(@Nonnull InputStream stream, @Nonnull String specificationResource) {
        try {
            this._specification = (ProctorSpecification)OBJECT_MAPPER.readValue(stream, ProctorSpecification.class);
            this.exportJsonSpecification(OBJECT_MAPPER.writeValueAsString((Object)this._specification));
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Unable to read proctor specification from " + specificationResource, e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException("Unable to read proctor specification from " + specificationResource, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read proctor specification from " + specificationResource, e);
        }
    }

    public void setSpecification(@Nonnull ProctorSpecification specification) {
        this._specification = (ProctorSpecification)Preconditions.checkNotNull((Object)specification, (Object)"Null specifications are not supported");
    }

    public void setFunctionMapper(@Nonnull FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    @Nonnull
    public AbstractJsonProctorLoader getLoader() {
        if (this.classResourcePath == null == (this.filePath == null)) {
            throw new IllegalStateException("Must have exactly one of classResourcePath or filePath");
        }
        ProctorSpecification specification = (ProctorSpecification)Preconditions.checkNotNull((Object)this._specification, (Object)"Missing specification");
        if (this.classResourcePath != null) {
            return new ClasspathProctorLoader(specification, this.classResourcePath, this.functionMapper);
        }
        FileProctorLoader loader = new FileProctorLoader(specification, this.filePath, this.functionMapper);
        loader.setDiffReporter(this.diffReporter);
        return loader;
    }

    public void setDiffReporter(AbstractProctorDiffReporter diffReporter) {
        if (diffReporter == null) {
            throw new UnsupportedOperationException("diff reporter can't be null use AbstractProctorDiffReporter for nop implementation");
        }
        this.diffReporter = diffReporter;
    }

    protected void exportJsonSpecification(String jsonSpec) {
        ManagedVariable managedVariable = ManagedVariable.builder().setName("specification").setValue((Object)jsonSpec).build();
        VAR_EXPORTER.export(managedVariable);
    }
}

