/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.ProctorLoadResult;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.RandomTestChooser;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.StandardTestChooser;
import com.indeed.proctor.common.TestChooser;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.proctor.common.model.TestType;
import com.indeed.util.varexport.VarExporter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;

public class Proctor {
    public static final Proctor EMPTY = Proctor.createEmptyProctor();
    static final long INT_RANGE = 0xFFFFFFFFL;
    private final TestMatrixArtifact matrix;
    private final ProctorLoadResult loadResult;
    @Nonnull
    private final Map<String, TestChooser<?>> testChoosers;
    private final Map<String, ConsumableTestDefinition> testDefinitions = Maps.newLinkedHashMap();

    @Nonnull
    public static Proctor construct(@Nonnull TestMatrixArtifact matrix, ProctorLoadResult loadResult, FunctionMapper functionMapper) {
        ExpressionFactory expressionFactory = RuleEvaluator.EXPRESSION_FACTORY;
        LinkedHashMap testChoosers = Maps.newLinkedHashMap();
        LinkedHashMap versions = Maps.newLinkedHashMap();
        for (Map.Entry<String, ConsumableTestDefinition> entry : matrix.getTests().entrySet()) {
            String testName = entry.getKey();
            ConsumableTestDefinition testDefinition = entry.getValue();
            TestType testType = testDefinition.getTestType();
            TestChooser<Void> testChooser = TestType.RANDOM.equals(testType) ? new RandomTestChooser(expressionFactory, functionMapper, testName, testDefinition) : new StandardTestChooser(expressionFactory, functionMapper, testName, testDefinition);
            testChoosers.put(testName, testChooser);
            versions.put(testName, testDefinition.getVersion());
        }
        return new Proctor(matrix, loadResult, testChoosers);
    }

    @Nonnull
    private static Proctor createEmptyProctor() {
        Audit audit = new Audit();
        audit.setUpdated(0L);
        audit.setUpdatedBy("nobody");
        audit.setVersion("");
        TestMatrixArtifact testMatrix = new TestMatrixArtifact();
        testMatrix.setAudit(audit);
        ProctorLoadResult loadResult = ProctorLoadResult.emptyResult();
        Map<String, TestChooser<?>> choosers = Collections.emptyMap();
        return new Proctor(testMatrix, loadResult, choosers);
    }

    @VisibleForTesting
    Proctor(TestMatrixArtifact matrix, ProctorLoadResult loadResult, @Nonnull Map<String, TestChooser<?>> testChoosers) {
        this.matrix = matrix;
        this.loadResult = loadResult;
        this.testChoosers = testChoosers;
        for (Map.Entry<String, TestChooser<?>> entry : testChoosers.entrySet()) {
            this.testDefinitions.put(entry.getKey(), entry.getValue().getTestDefinition());
        }
        VarExporter.forNamespace((String)Proctor.class.getSimpleName()).includeInGlobal().export((Object)this, "");
        VarExporter.forNamespace((String)DetailedExport.class.getSimpleName()).export((Object)new DetailedExport(), "");
    }

    @Nonnull
    public ProctorResult determineTestGroups(TestType testType, String identifier, @Nonnull Map<String, Object> context, @Nonnull Map<String, Integer> forceGroups) {
        Identifiers identifiers = new Identifiers(testType, identifier);
        return this.determineTestGroups(identifiers, context, forceGroups);
    }

    @Nonnull
    public ProctorResult determineTestGroups(@Nonnull Identifiers identifiers, @Nonnull Map<String, Object> inputContext, @Nonnull Map<String, Integer> forceGroups) {
        return this.determineTestGroups(identifiers, inputContext, forceGroups, Collections.emptyList());
    }

    @Nonnull
    public ProctorResult determineTestGroups(@Nonnull Identifiers identifiers, @Nonnull Map<String, Object> inputContext, @Nonnull Map<String, Integer> forceGroups, @Nonnull Collection<String> testNameFilter) {
        LinkedHashMap testGroups = Maps.newLinkedHashMap();
        Map filteredChoosers = this.testChoosers;
        if (!testNameFilter.isEmpty()) {
            filteredChoosers = Maps.filterKeys(filteredChoosers, (Predicate)Predicates.in(testNameFilter));
        }
        for (Map.Entry<String, TestChooser<?>> entry : filteredChoosers.entrySet()) {
            TestBucket forcedTestBucket;
            String identifier;
            String testName = entry.getKey();
            Integer forceGroupBucket = forceGroups.get(testName);
            TestChooser<?> testChooser = entry.getValue();
            if (testChooser instanceof StandardTestChooser) {
                TestType testType = testChooser.getTestDefinition().getTestType();
                identifier = identifiers.getIdentifier(testType);
                if (identifier == null) {
                    continue;
                }
            } else {
                if (!identifiers.isRandomEnabled()) continue;
                identifier = null;
            }
            if (forceGroupBucket != null && (forcedTestBucket = testChooser.getTestBucket(forceGroupBucket)) != null) {
                testGroups.put(testName, forcedTestBucket);
                continue;
            }
            TestBucket testBucket = identifier == null ? ((RandomTestChooser)testChooser).choose(null, inputContext) : ((StandardTestChooser)testChooser).choose(identifier, inputContext);
            if (testBucket == null) continue;
            testGroups.put(testName, testBucket);
            testChooser.getTestDefinition();
        }
        Audit audit = (Audit)Preconditions.checkNotNull((Object)this.matrix.getAudit(), (Object)"Missing audit");
        return new ProctorResult(audit.getVersion(), (Map<String, TestBucket>)testGroups, this.testDefinitions);
    }

    TestMatrixArtifact getArtifact() {
        return this.matrix;
    }

    public ConsumableTestDefinition getTestDefinition(String name) {
        return this.matrix.getTests().get(name);
    }

    public ProctorLoadResult getLoadResult() {
        return this.loadResult;
    }

    public void appendAllTests(Writer sb) {
        this.appendTests(sb, Predicates.alwaysTrue());
    }

    public void appendTests(Writer sb, final TestType type) {
        this.appendTests(sb, new Predicate<TestChooser<?>>(){

            public boolean apply(TestChooser<?> input) {
                assert (null != input);
                return type == input.getTestDefinition().getTestType();
            }
        });
    }

    public void appendTestsNameFiltered(Writer sb, Collection<String> testNameFilter) {
        Function getTestName = new Function<TestChooser<?>, String>(){

            public String apply(TestChooser<?> input) {
                return input.getTestName();
            }
        };
        this.appendTests(sb, Predicates.compose((Predicate)Predicates.in(testNameFilter), (Function)getTestName));
    }

    public void appendTests(Writer sb, @Nonnull Predicate<TestChooser<?>> shouldIncludeTest) {
        NumberFormat fmt = NumberFormat.getPercentInstance(Locale.US);
        fmt.setMaximumFractionDigits(2);
        PrintWriter writer = new PrintWriter(sb);
        for (Map.Entry<String, TestChooser<?>> entry : this.testChoosers.entrySet()) {
            String testName = entry.getKey();
            TestChooser<?> chooser = entry.getValue();
            if (!shouldIncludeTest.apply(chooser)) continue;
            writer.append(testName).append(" : ");
            chooser.printTestBuckets(writer);
            writer.println();
        }
    }

    public void appendTestMatrix(Writer writer) throws IOException {
        ProctorUtils.serializeArtifact(writer, this.matrix);
    }

    public void appendTestMatrixFiltered(Writer writer, Collection<String> testNameFilter) throws IOException {
        TestMatrixArtifact filtered = new TestMatrixArtifact();
        filtered.setAudit(this.matrix.getAudit());
        filtered.setTests(Maps.filterKeys(this.matrix.getTests(), (Predicate)Predicates.in(testNameFilter)));
        ProctorUtils.serializeArtifact(writer, filtered);
    }

    class DetailedExport {
        DetailedExport() {
        }
    }
}

