/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.indeed.proctor.common.MissingTestMatrixException;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorLoadResult;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.ProvidedContext;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.common.model.Audit;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.util.core.DataLoadingTimerTask;
import com.indeed.util.varexport.Export;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.el.FunctionMapper;
import org.apache.log4j.Logger;

public abstract class AbstractProctorLoader
extends DataLoadingTimerTask
implements Supplier<Proctor> {
    private static final Logger LOGGER = Logger.getLogger(AbstractProctorLoader.class);
    @Nonnull
    protected final Map<String, TestSpecification> requiredTests;
    @Nullable
    private Proctor current = null;
    @Nullable
    private Audit lastAudit = null;
    @Nullable
    private String lastLoadErrorMessage = "load never attempted";
    @Nonnull
    private final FunctionMapper functionMapper;
    private final ProvidedContext providedContext;

    public AbstractProctorLoader(@Nonnull Class<?> cls, @Nonnull ProctorSpecification specification, @Nonnull FunctionMapper functionMapper) {
        super(cls.getSimpleName());
        this.requiredTests = specification.getTests();
        this.providedContext = this.createProvidedContext(specification);
        if (!this.providedContext.isEvaluable()) {
            LOGGER.debug((Object)"providedContext Objects missing necessary functions for validation, rules will not be tested.");
        }
        this.functionMapper = functionMapper;
    }

    protected ProvidedContext createProvidedContext(ProctorSpecification specification) {
        return ProctorUtils.convertContextToTestableMap(specification.getProvidedContext());
    }

    @Nullable
    abstract TestMatrixArtifact loadTestMatrix() throws IOException, MissingTestMatrixException;

    @Nonnull
    abstract String getSource();

    public boolean load() {
        Proctor newProctor;
        try {
            newProctor = this.doLoad();
        }
        catch (Throwable t) {
            this.lastLoadErrorMessage = t.getMessage();
            throw new RuntimeException("Unable to reload proctor from " + this.getSource(), t);
        }
        this.lastLoadErrorMessage = null;
        if (newProctor == null) {
            return false;
        }
        this.current = newProctor;
        Audit lastAudit = (Audit)Preconditions.checkNotNull((Object)this.lastAudit, (Object)"Missing last audit");
        this.setDataVersion(lastAudit.getVersion() + " @ " + lastAudit.getUpdated() + " by " + lastAudit.getUpdatedBy());
        LOGGER.info((Object)("Successfully loaded new test matrix definition: " + lastAudit.getVersion() + " @ " + lastAudit.getUpdated() + " by " + lastAudit.getUpdatedBy()));
        return true;
    }

    @Nullable
    public Proctor doLoad() throws IOException, MissingTestMatrixException {
        TestMatrixArtifact testMatrix = this.loadTestMatrix();
        if (testMatrix == null) {
            throw new MissingTestMatrixException("Failed to load Test Matrix from " + this.getSource());
        }
        ProctorLoadResult loadResult = ProctorUtils.verifyAndConsolidate(testMatrix, this.getSource(), this.requiredTests, this.functionMapper, this.providedContext);
        Audit newAudit = testMatrix.getAudit();
        if (this.lastAudit != null) {
            Audit audit = (Audit)Preconditions.checkNotNull((Object)newAudit, (Object)"Missing audit");
            if (this.lastAudit.getVersion() == audit.getVersion()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Not reloading " + this.getSource() + " test matrix definition because audit is unchanged: " + this.lastAudit.getVersion() + " @ " + this.lastAudit.getUpdated() + " by " + this.lastAudit.getUpdatedBy()));
                }
                return null;
            }
        }
        Proctor proctor = Proctor.construct(testMatrix, loadResult, this.functionMapper);
        this.lastAudit = newAudit;
        return proctor;
    }

    @Nullable
    public Proctor get() {
        return this.current;
    }

    @Nullable
    @Export(name="last-audit")
    public Audit getLastAudit() {
        return this.lastAudit;
    }

    @Nullable
    @Export(name="last-error", doc="The last error message thrown by the loader. null indicates a successful load.")
    public String getLastLoadErrorMessage() {
        return this.lastLoadErrorMessage;
    }

    public boolean isLoadedDataSuccessfullyRecently() {
        return this.dataLoadTimer.isLoadedDataSuccessfullyRecently();
    }
}

