/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.TestGroupsGenerator;
import java.util.HashMap;
import java.util.Map;

public class TestGroupsJavaGenerator
extends TestGroupsGenerator {
    public void generate(String input, String target, String packageName, String groupsClass, String groupsManagerClass, String contextClass) throws CodeGenException {
        String templatePath = "/com/indeed/proctor/consumer/ant/";
        String groupsTemplateName = "groups.ftl";
        String groupsManagerTemplateName = "groups-manager.ftl";
        String payloadTemplateName = "payload.ftl";
        String contextTemplateName = "context.ftl";
        String payloadClass = groupsClass + "Payload";
        String fileExtension = ".java";
        HashMap baseContext = Maps.newHashMap();
        baseContext.put("groupsClassName", groupsClass);
        baseContext.put("groupsManagerClassName", groupsManagerClass);
        baseContext.put("payloadClassName", groupsClass + "Payload");
        if (!Strings.isNullOrEmpty((String)groupsClass)) {
            this.generate(input, target, baseContext, packageName, groupsClass, "/com/indeed/proctor/consumer/ant/", "groups.ftl", ".java");
        }
        if (!Strings.isNullOrEmpty((String)groupsManagerClass)) {
            this.generate(input, target, baseContext, packageName, groupsManagerClass, "/com/indeed/proctor/consumer/ant/", "groups-manager.ftl", ".java");
        }
        if (!Strings.isNullOrEmpty((String)groupsClass)) {
            this.generate(input, target, baseContext, packageName, payloadClass, "/com/indeed/proctor/consumer/ant/", "payload.ftl", ".java");
        }
        if (!Strings.isNullOrEmpty((String)contextClass)) {
            this.generate(input, target, baseContext, packageName, contextClass, "/com/indeed/proctor/consumer/ant/", "context.ftl", ".java");
        }
    }

    @Override
    protected void addPayloadToTestDef(Map<String, Object> testDef, PayloadType specifiedPayloadType) {
        testDef.put("payloadJavaClass", specifiedPayloadType.javaClassName);
        testDef.put("payloadAccessorName", specifiedPayloadType.javaAccessorName);
    }

    public static void main(String[] args) throws CodeGenException {
        if (args.length != 6) {
            System.err.println("java " + TestGroupsJavaGenerator.class.getCanonicalName() + " input.json outputDirectory packageName groupsClassName groupsManagerClassName contextClassName");
            System.exit(-4);
        }
        TestGroupsJavaGenerator generator = new TestGroupsJavaGenerator();
        String input = args[0];
        String target = args[1];
        String packageName = args[2];
        String groupsClass = args[3];
        String groupsManagerClass = args[4];
        String contextClass = args[5];
        generator.generate(input, target, packageName, groupsClass, groupsManagerClass, contextClass);
    }
}

