/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.SpecificationResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ViewProctorSpecificationServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(ViewProctorSpecificationServlet.class);
    private static final String DEFAULT_PROCTOR_SPEC_PATH = "/WEB-INF/proctor/proctor-specification.json";
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();
    private String proctorSpecPath = "/WEB-INF/proctor/proctor-specification.json";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String proctorSpecPathParameter = config.getInitParameter("proctorSpecPath");
        if (StringUtils.isNotBlank((CharSequence)proctorSpecPathParameter)) {
            this.proctorSpecPath = proctorSpecPathParameter;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        InputStream resourceAsStream;
        resp.setContentType("text/plain;charset=UTF-8");
        if (this.proctorSpecPath.startsWith("classpath:")) {
            String proctorSpecClassPath = this.proctorSpecPath.substring("classpath:".length());
            resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(proctorSpecClassPath);
        } else {
            resourceAsStream = this.getServletContext().getResourceAsStream(this.proctorSpecPath);
        }
        SpecificationResult results = new SpecificationResult();
        try {
            if (resourceAsStream == null) {
                throw new ServletException("No resource stream for proctorSpecPath " + this.proctorSpecPath);
            }
            ProctorSpecification specification = (ProctorSpecification)OBJECT_MAPPER.readValue(resourceAsStream, ProctorSpecification.class);
            results.setSpecification(specification);
        }
        catch (Throwable t) {
            String message = "Unable to parse specification in " + this.proctorSpecPath;
            LOGGER.error(message, t);
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            t.printStackTrace(writer);
            results.setError(message);
            results.setException(sw.toString());
        }
        PrintWriter writer = resp.getWriter();
        OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, (Object)results);
    }
}

