/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestType;
import com.indeed.proctor.consumer.Bucket;
import com.indeed.proctor.consumer.CannedProctorResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CannedProctorResults {
    public static ProctorResult of(Bucket<?> ... results) {
        HashMap buckets = Maps.newHashMapWithExpectedSize((int)results.length);
        HashMap testVersions = Maps.newHashMap();
        for (Bucket<?> result : results) {
            String testName = result.getClass().getSimpleName().toLowerCase();
            int testValue = result.getValue();
            TestBucket testBucket = new TestBucket(testName, testValue, testName);
            Preconditions.checkState((!buckets.containsKey(testName) ? 1 : 0) != 0, (String)"Attempted to provide two values for dummy test bucket %s", (Object)testName);
            buckets.put(testName, testBucket);
            ConsumableTestDefinition testDefinition = CannedProctorResults.addTestDefinition(testName, testVersions);
            testDefinition.getBuckets().add(testBucket);
        }
        return new ProctorResult("", (Map)buckets, Collections.emptyMap(), (Map)testVersions);
    }

    public static ProctorResult of(CannedProctorResult<?> ... results) {
        HashMap buckets = Maps.newHashMapWithExpectedSize((int)results.length);
        HashMap testVersions = Maps.newHashMap();
        for (CannedProctorResult<?> result : results) {
            String testName = result.testVal.getClass().getSimpleName().toLowerCase();
            int testValue = result.testVal.getValue();
            TestBucket testBucket = new TestBucket(testName, testValue, testName, result.payload);
            Preconditions.checkState((!buckets.containsKey(testName) ? 1 : 0) != 0, (String)"Attempted to provide two values for dummy test bucket %s", (Object)testName);
            buckets.put(testName, testBucket);
            ConsumableTestDefinition testDefinition = CannedProctorResults.addTestDefinition(testName, testVersions);
            testDefinition.getBuckets().add(testBucket);
        }
        return new ProctorResult("", (Map)buckets, Collections.emptyMap(), (Map)testVersions);
    }

    private static ConsumableTestDefinition addTestDefinition(String testName, Map<String, ConsumableTestDefinition> testVersions) {
        ConsumableTestDefinition testDefinition = testVersions.get(testName);
        if (null == testDefinition) {
            testDefinition = new ConsumableTestDefinition("", null, TestType.RANDOM, null, (List)Lists.newArrayList(), (List)Lists.newArrayListWithCapacity((int)1), Collections.emptyMap(), null);
            testVersions.put(testName, testDefinition);
        }
        return testDefinition;
    }
}

