/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.Bucket;
import com.indeed.proctor.consumer.Test;
import com.indeed.proctor.consumer.logging.ExposureLogger;
import com.indeed.proctor.consumer.logging.TestUsageObserver;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGroups {
    private static final Logger LOGGER = LogManager.getLogger(AbstractGroups.class);
    private final ProctorResult proctorResult;
    @CheckForNull
    private TestUsageObserver testUsageObserver;
    @CheckForNull
    private final ExposureLogger exposureLogger;
    protected static final char GROUPS_SEPARATOR = ',';
    protected static final char ALLOCATION_GROUP_SEPARATOR = ':';
    protected static final char TESTNAME_BUCKET_CONNECTOR = '-';

    protected AbstractGroups(ProctorResult proctorResult, @Nullable TestUsageObserver testUsageObserver, @Nullable ExposureLogger exposureLogger) {
        this.proctorResult = proctorResult;
        this.testUsageObserver = testUsageObserver;
        this.exposureLogger = exposureLogger;
    }

    protected AbstractGroups(ProctorResult proctorResult, @Nullable TestUsageObserver testUsageObserver) {
        this(proctorResult, testUsageObserver, null);
    }

    protected AbstractGroups(ProctorResult proctorResult) {
        this(proctorResult, null);
    }

    protected int overrideDeterminedBucketValue(String testName, @Nonnull TestBucket determinedBucket) {
        return determinedBucket.getValue();
    }

    @Deprecated
    protected boolean isBucketActive(String testName, int value) {
        return this.getActiveBucket(testName).filter(testBucket -> value == testBucket.getValue()).isPresent();
    }

    protected boolean isBucketActive(String testName, int value, int defaultValue) {
        return value == this.getValue(testName, defaultValue);
    }

    protected int getValue(String testName, int defaultValue) {
        return this.getActiveBucket(testName).map(TestBucket::getValue).orElse(defaultValue);
    }

    protected final int getValueWithoutMarkingUsage(String testName, int defaultValue) {
        return this.getActiveBucketWithoutMarkingUsage(testName).map(TestBucket::getValue).orElse(defaultValue);
    }

    protected final Optional<TestBucket> getActiveBucket(String testName) {
        Optional<TestBucket> bucketOpt = this.getActiveBucketWithoutMarkingUsage(testName);
        bucketOpt.ifPresent(bucket -> {
            if (this.testUsageObserver != null) {
                this.testUsageObserver.markUsedForToggling(testName);
            }
            if (this.exposureLogger != null) {
                this.exposureLogger.logExposureInfo(this.proctorResult, testName);
            }
        });
        return bucketOpt;
    }

    public final void markTestsUsed(Collection<String> testNames) {
        if (this.testUsageObserver != null) {
            this.testUsageObserver.markUsedForToggling(testNames);
        }
    }

    private Optional<TestBucket> getActiveBucketWithoutMarkingUsage(String testName) {
        TestBucket bucket = (TestBucket)this.proctorResult.getBuckets().get(testName);
        if (bucket == null) {
            return Optional.empty();
        }
        int overrideBucketValue = this.overrideDeterminedBucketValue(testName, bucket);
        if (overrideBucketValue != bucket.getValue()) {
            Optional<TestBucket> overrideBucketOpt = AbstractGroups.getTestBucketWithValueOptional(this.proctorResult, testName, overrideBucketValue);
            if (overrideBucketOpt.isPresent()) {
                return overrideBucketOpt;
            }
            LOGGER.warn("Overriding bucket value " + overrideBucketValue + " for test '" + testName + "' does not match any bucket in test definition, using determined bucket value " + bucket.getValue());
        }
        return Optional.of(bucket);
    }

    @Deprecated
    @Nonnull
    protected Payload getPayload(String testName) {
        return this.getActiveBucket(testName).map(TestBucket::getPayload).orElse(Payload.EMPTY_PAYLOAD);
    }

    @Nonnull
    protected Payload getPayload(String testName, @Nonnull Bucket<?> fallbackBucket) {
        return this.getPayload(testName, fallbackBucket.getValue());
    }

    @Nonnull
    protected final Payload getPayload(String testName, int fallbackBucketValue) {
        Optional<TestBucket> activeBucketOpt = this.getActiveBucket(testName);
        Optional<TestBucket> resultBucketOpt = activeBucketOpt.isPresent() ? activeBucketOpt : Optional.ofNullable(this.getTestBucketWithValue(testName, fallbackBucketValue));
        return resultBucketOpt.map(TestBucket::getPayload).orElse(Payload.EMPTY_PAYLOAD);
    }

    @CheckForNull
    protected final TestBucket getTestBucketForBucket(String testName, Bucket<?> targetBucket) {
        return this.getTestBucketWithValue(testName, targetBucket.getValue());
    }

    private static Optional<TestBucket> getTestBucketWithValueOptional(ProctorResult proctorResult, String testName, int bucketValue) {
        return Optional.ofNullable(proctorResult.getTestDefinitions()).map(testDefinitions -> (ConsumableTestDefinition)testDefinitions.get(testName)).map(ConsumableTestDefinition::getBuckets).flatMap(buckets -> buckets.stream().filter(testBucket -> testBucket.getValue() == bucketValue).findFirst());
    }

    @CheckForNull
    final TestBucket getTestBucketWithValue(String testName, int bucketValue) {
        return AbstractGroups.getTestBucketWithValueOptional(this.proctorResult, testName, bucketValue).orElse(null);
    }

    public String toLongString() {
        if (this.isEmpty()) {
            return "";
        }
        Map buckets = this.proctorResult.getBuckets();
        StringBuilder sb = new StringBuilder(buckets.size() * 10);
        for (String testName : buckets.keySet()) {
            sb.append(testName).append('-').append(this.getActiveBucketWithoutMarkingUsage(testName).map(TestBucket::getName).orElse("unknown")).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    @Deprecated
    public String toString() {
        return this.toLoggingString();
    }

    public String toLoggingString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.proctorResult.getBuckets().size() * 10);
        this.appendTestGroups(sb);
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Deprecated
    public final StringBuilder buildTestGroupString() {
        StringBuilder sb = new StringBuilder(this.proctorResult.getBuckets().size() * 10);
        this.appendTestGroups(sb);
        return sb;
    }

    protected boolean isEmpty() {
        return this.proctorResult.getBuckets().isEmpty();
    }

    public final void appendTestGroups(StringBuilder sb) {
        this.appendTestGroups(sb, ',');
    }

    public void appendTestGroups(StringBuilder sb, char separator) {
        List<String> testNames = this.getLoggingTestNames();
        this.appendTestGroupsWithAllocations(sb, separator, testNames);
    }

    protected final List<String> getLoggingTestNames() {
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        Map buckets = this.proctorResult.getBuckets();
        return buckets.keySet().stream().filter(testName -> {
            ConsumableTestDefinition consumableTestDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            return consumableTestDefinition == null || !consumableTestDefinition.getSilent();
        }).filter(testName -> this.getValueWithoutMarkingUsage((String)testName, -1) >= 0).collect(Collectors.toList());
    }

    protected final void appendTestGroupsWithAllocations(StringBuilder sb, char separator, List<String> testNames) {
        for (String testName : testNames) {
            this.getActiveBucketWithoutMarkingUsage(testName).ifPresent(testBucket -> {
                Allocation allocation = (Allocation)this.proctorResult.getAllocations().get(testName);
                if (allocation == null) {
                    sb.append(testName).append(testBucket.getValue()).append(separator);
                } else if (!Strings.isNullOrEmpty((String)allocation.getId())) {
                    sb.append(allocation.getId()).append(':').append(testName).append(testBucket.getValue()).append(separator);
                }
            });
        }
    }

    public final Map<String, Integer> getJavaScriptConfig() {
        return this.getJavaScriptConfig((String n) -> true);
    }

    public final Map<String, Integer> getJavaScriptConfig(Set<String> testNames) {
        return this.getJavaScriptConfig(testNames::contains);
    }

    private Map<String, Integer> getJavaScriptConfig(Predicate<String> testNameFilter) {
        return this.proctorResult.getBuckets().keySet().stream().filter(testNameFilter).map(testName -> new AbstractMap.SimpleEntry<String, Integer>((String)testName, this.getValue((String)testName, -1))).filter(e -> (Integer)e.getValue() >= 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Deprecated
    public <E extends Test> List<List<Object>> getJavaScriptConfig(E[] tests) {
        return Arrays.stream(tests).map(test -> Arrays.asList(this.getValue(test.getName(), test.getFallbackValue()), this.getPayload(test.getName(), test.getFallbackValue()).fetchAValue())).collect(Collectors.toList());
    }

    public ProctorResult getAsProctorResult() {
        SortedMap customBuckets = Maps.transformEntries((SortedMap)((SortedMap)this.proctorResult.getBuckets()), (testName, bucket) -> this.getActiveBucketWithoutMarkingUsage((String)testName).get());
        return new ProctorResult(this.proctorResult.getMatrixVersion(), Collections.unmodifiableSortedMap(customBuckets), Collections.unmodifiableSortedMap((SortedMap)this.proctorResult.getAllocations()), Collections.unmodifiableMap(this.proctorResult.getTestDefinitions()), this.proctorResult.getIdentifiers(), Collections.unmodifiableMap(this.proctorResult.getInputContext()));
    }

    public ProctorResult getRawProctorResult() {
        return ProctorResult.unmodifiableView((ProctorResult)this.proctorResult);
    }

    @Deprecated
    public ProctorResult getProctorResult() {
        return this.proctorResult;
    }
}

