/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.indeed.lsmtree.core.Generation;
import com.indeed.util.core.hash.MurmurHash;
import com.indeed.util.core.io.Closeables2;
import com.indeed.util.mmap.Memory;
import com.indeed.util.mmap.NativeBuffer;
import com.indeed.util.serialization.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class BloomFilter {
    private static final Logger log = Logger.getLogger(BloomFilter.class);
    private static final int NUM_HASHES = 6;
    private static final long PAGE_SIZE = 65536L;
    private static final long PAGE_OFFSET_MASK = 65535L;
    private static final long PAGE_BITS = Long.bitCount(65535L);
    private static final long ADDRESS_MASK = -65536L;

    private static long getHash(byte[] bytes, int seedValue) {
        long hash = MurmurHash.hash64((byte[])bytes, (int)seedValue);
        if (hash < 0L) {
            hash ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return hash;
    }

    public static final class MemoryManager
    implements Closeable {
        private static final AtomicInteger THREAD_NUMBERER = new AtomicInteger(0);
        private final Set<AddressSpace> addressSpaces = Sets.newLinkedHashSet();
        private final NativeBuffer physicalMemory;
        private final PageTableEntry[] activePages;
        private int activePagePointer;
        private int activePagesEnd;
        private final List<Memory> freePages = Lists.newArrayList();
        private final AtomicBoolean runCleaner = new AtomicBoolean(true);
        private final boolean mLock;
        private static final Comparator<ScoredPageTableEntry> SCORE_COMPARATOR = new Comparator<ScoredPageTableEntry>(){

            @Override
            public int compare(ScoredPageTableEntry o1, ScoredPageTableEntry o2) {
                return ComparisonChain.start().compare(o1.score, o2.score).result();
            }
        };

        public MemoryManager(long physicalSize, boolean mLock) {
            this.mLock = mLock;
            this.physicalMemory = new NativeBuffer(physicalSize &= 0xFFFFFFFFFFFF0000L, ByteOrder.LITTLE_ENDIAN);
            if (mLock) {
                this.physicalMemory.mlock(0L, physicalSize);
            }
            this.activePages = new PageTableEntry[(int)(physicalSize >>> (int)PAGE_BITS)];
            for (long i = 0L; i < physicalSize; i += 65536L) {
                this.freePages.add((Memory)this.physicalMemory.memory().slice(i, 65536L));
            }
            Thread cleaner = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    PageTableEntry[] pageTableEntryArray = MemoryManager.this.activePages;
                    synchronized (pageTableEntryArray) {
                        while (MemoryManager.this.runCleaner.get()) {
                            ArrayList scoredActivePages = Lists.newArrayListWithCapacity((int)MemoryManager.this.activePages.length);
                            PriorityQueue<ScoredPageTableEntry> bestInactivePages = new PriorityQueue<ScoredPageTableEntry>(10, SCORE_COMPARATOR);
                            int activeIndex = 0;
                            Set set = MemoryManager.this.addressSpaces;
                            synchronized (set) {
                                Object object;
                                ArrayList scoredInactivePages;
                                Iterator iterator = MemoryManager.this.addressSpaces.iterator();
                                block25: while (true) {
                                    Object addressSpace;
                                    if (!iterator.hasNext()) {
                                        scoredInactivePages = Lists.newArrayListWithCapacity((int)bestInactivePages.size());
                                        while (!bestInactivePages.isEmpty()) {
                                            scoredInactivePages.add(bestInactivePages.poll());
                                        }
                                        addressSpace = MemoryManager.this.freePages;
                                        synchronized (addressSpace) {
                                            break;
                                        }
                                    }
                                    addressSpace = (AddressSpace)iterator.next();
                                    double usefulness = ((AddressSpace)addressSpace).useful.doubleValue() / (double)((AddressSpace)addressSpace).total.get();
                                    object = ((AddressSpace)addressSpace).pageTable;
                                    int n = ((PageTableEntry[])object).length;
                                    int n2 = 0;
                                    while (true) {
                                        PageTableEntry pte;
                                        if (n2 >= n) continue block25;
                                        PageTableEntry pageTableEntry = pte = object[n2];
                                        synchronized (pageTableEntry) {
                                            double score = (double)pte.requestsCounter * usefulness;
                                            if (pte.memory != null) {
                                                scoredActivePages.add(new ScoredPageTableEntry(score, pte));
                                            } else if (bestInactivePages.size() < MemoryManager.this.activePages.length) {
                                                bestInactivePages.add(new ScoredPageTableEntry(score, pte));
                                            } else if (score < ((ScoredPageTableEntry)bestInactivePages.peek()).score) {
                                                bestInactivePages.poll();
                                                bestInactivePages.add(new ScoredPageTableEntry(score, pte));
                                            }
                                        }
                                        ++n2;
                                    }
                                    break;
                                }
                                {
                                    while (!scoredInactivePages.isEmpty() && !MemoryManager.this.freePages.isEmpty()) {
                                        ScoredPageTableEntry scoreAndPte = (ScoredPageTableEntry)scoredInactivePages.remove(scoredInactivePages.size() - 1);
                                        PageTableEntry pte = scoreAndPte.pageTableEntry;
                                        object = pte;
                                        synchronized (object) {
                                            if (pte.memory == null) {
                                                Memory freePage = (Memory)MemoryManager.this.freePages.remove(MemoryManager.this.freePages.size() - 1);
                                                try {
                                                    pte.addressSpace.loadPage(pte.index, freePage);
                                                    pte.memory = freePage;
                                                }
                                                catch (IOException e) {
                                                    log.error((Object)"error", (Throwable)e);
                                                }
                                            }
                                        }
                                        scoredActivePages.add(scoreAndPte);
                                    }
                                }
                                Collections.sort(scoredActivePages, SCORE_COMPARATOR);
                                int inactiveIndex = scoredInactivePages.size() - 1;
                                Memory freePage = null;
                                while (inactiveIndex >= 0) {
                                    PageTableEntry inactivePte;
                                    PageTableEntry activePte;
                                    ScoredPageTableEntry inactiveEntry;
                                    block46: {
                                        inactiveEntry = (ScoredPageTableEntry)scoredInactivePages.get(inactiveIndex);
                                        if (freePage == null) {
                                            if (activeIndex >= scoredActivePages.size()) break;
                                            ScoredPageTableEntry activeEntry = (ScoredPageTableEntry)scoredActivePages.get(activeIndex);
                                            ++activeIndex;
                                            if (inactiveEntry.score < activeEntry.score) break;
                                            PageTableEntry e = activePte = activeEntry.pageTableEntry;
                                            synchronized (e) {
                                                try {
                                                    freePage = activePte.addressSpace.freePage(activePte.index);
                                                    if (freePage == null) {
                                                    }
                                                    break block46;
                                                }
                                                catch (IOException e2) {
                                                    log.error((Object)"error", (Throwable)e2);
                                                }
                                                continue;
                                            }
                                        }
                                    }
                                    --inactiveIndex;
                                    activePte = inactivePte = inactiveEntry.pageTableEntry;
                                    synchronized (activePte) {
                                        if (inactivePte.memory != null) {
                                            continue;
                                        }
                                        try {
                                            inactivePte.addressSpace.loadPage(inactivePte.index, freePage);
                                        }
                                        catch (IOException e) {
                                            log.error((Object)"error", (Throwable)e);
                                            continue;
                                        }
                                        inactivePte.memory = freePage;
                                        freePage = null;
                                    }
                                    scoredActivePages.set(activeIndex - 1, inactiveEntry);
                                }
                                for (AddressSpace addressSpace : MemoryManager.this.addressSpaces) {
                                    long update;
                                    long total;
                                    long update2;
                                    long useful;
                                    do {
                                        useful = addressSpace.useful.get();
                                        update2 = useful * 9L / 10L;
                                    } while (!addressSpace.useful.compareAndSet(useful, Math.max(update2, 1L)));
                                    do {
                                        total = addressSpace.total.get();
                                        update = total * 9L / 10L;
                                    } while (!addressSpace.total.compareAndSet(total, Math.max(update, 2L)));
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("usefulness for filter " + addressSpace.file.getPath() + " - useful: " + useful + " total: " + total + " usefulness: " + (double)useful / (double)total));
                                    }
                                    PageTableEntry[] pageTableEntryArray2 = addressSpace.pageTable;
                                    int n = pageTableEntryArray2.length;
                                    for (int i = 0; i < n; ++i) {
                                        PageTableEntry pte;
                                        PageTableEntry pageTableEntry = pte = pageTableEntryArray2[i];
                                        synchronized (pageTableEntry) {
                                            pte.requestsCounter = pte.requestsCounter * 9L / 10L;
                                            continue;
                                        }
                                    }
                                }
                            }
                            Collections.sort(scoredActivePages, SCORE_COMPARATOR);
                            MemoryManager.this.activePagePointer = 0;
                            MemoryManager.this.activePagesEnd = Math.min(scoredActivePages.size(), MemoryManager.this.activePages.length);
                            for (int i = 0; i < MemoryManager.this.activePagesEnd; ++i) {
                                ((MemoryManager)MemoryManager.this).activePages[i] = ((ScoredPageTableEntry)scoredActivePages.get((int)i)).pageTableEntry;
                            }
                            try {
                                MemoryManager.this.activePages.wait(10000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        return;
                    }
                }
            }, "PageTableCleanerThread-" + THREAD_NUMBERER.getAndIncrement());
            cleaner.setDaemon(true);
            cleaner.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AddressSpace openReadOnly(File file, long length) throws IOException {
            AddressSpace addressSpace = new AddressSpace(file, length, true);
            Set<AddressSpace> set = this.addressSpaces;
            synchronized (set) {
                this.addressSpaces.add(addressSpace);
            }
            return addressSpace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AddressSpace open(File file, long length) throws IOException {
            AddressSpace addressSpace = new AddressSpace(file, length, false);
            Set<AddressSpace> set = this.addressSpaces;
            synchronized (set) {
                this.addressSpaces.add(addressSpace);
            }
            return addressSpace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Memory getFreePage() throws IOException {
            PageTableEntry[] pageTableEntryArray = this.freePages;
            synchronized (this.freePages) {
                if (!this.freePages.isEmpty()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.freePages.remove(this.freePages.size() - 1);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                pageTableEntryArray = this.activePages;
                synchronized (this.activePages) {
                    while (this.activePagePointer < this.activePagesEnd) {
                        PageTableEntry pte = this.activePages[this.activePagePointer];
                        Memory freePage = pte.addressSpace.freePage(pte.index);
                        if (freePage != null) {
                            ++this.activePagePointer;
                            if (this.activePagePointer > this.activePages.length / 5) {
                                this.activePages.notify();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return freePage;
                        }
                        ++this.activePagePointer;
                    }
                    this.activePages.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
        }

        @Override
        public void close() {
            if (this.mLock) {
                this.physicalMemory.munlock(0L, this.physicalMemory.memory().length());
            }
            this.runCleaner.set(false);
            Closeables2.closeQuietly((Closeable)this.physicalMemory, (Logger)log);
        }

        private static final class ScoredPageTableEntry {
            final double score;
            final PageTableEntry pageTableEntry;

            private ScoredPageTableEntry(double score, PageTableEntry pageTableEntry) {
                this.score = score;
                this.pageTableEntry = pageTableEntry;
            }
        }

        private static final class PageTableEntry {
            long requestsCounter;
            int refCount;
            boolean dirty;
            Memory memory;
            final AddressSpace addressSpace;
            final int index;

            private PageTableEntry(AddressSpace addressSpace, int index) {
                this.addressSpace = addressSpace;
                this.index = index;
            }
        }

        public final class AddressSpace
        implements Closeable {
            private final File file;
            private final RandomAccessFile raf;
            private final byte[] pageBuffer = new byte[65536];
            private final PageTableEntry[] pageTable;
            private final long length;
            private final AtomicLong useful = new AtomicLong(50L);
            private final AtomicLong total = new AtomicLong(100L);

            public AddressSpace(File file, long length, boolean readOnly) throws IOException {
                this.file = file;
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.length = length;
                if (length > this.raf.length()) {
                    this.raf.setLength(length);
                }
                int numPages = (int)(length - 1L >> (int)PAGE_BITS) + 1;
                this.pageTable = new PageTableEntry[numPages];
                for (int i = 0; i < numPages; ++i) {
                    this.pageTable[i] = new PageTableEntry(this, i);
                }
            }

            private PageTableEntry getPageTableEntry(long address) {
                return this.pageTable[(int)(address >>> (int)PAGE_BITS)];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadPage(int index, Memory freePage) throws IOException {
                long address = (long)index << (int)PAGE_BITS;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading page in file " + this.file.getPath() + " at address " + address));
                }
                int pageLength = (int)Math.min(65536L, this.length - address);
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    this.raf.seek(address);
                    this.raf.readFully(this.pageBuffer, 0, pageLength);
                    freePage.putBytes(0L, this.pageBuffer, 0, pageLength);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void syncPage(int index) throws IOException {
                PageTableEntry pte = this.pageTable[index];
                long address = (long)index << (int)PAGE_BITS;
                PageTableEntry pageTableEntry = pte;
                synchronized (pageTableEntry) {
                    if (pte.dirty) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("synchronizing page in file " + this.file.getPath() + " at address " + address));
                        }
                        int pageLength = (int)Math.min(65536L, this.length - address);
                        RandomAccessFile randomAccessFile = this.raf;
                        synchronized (randomAccessFile) {
                            pte.memory.getBytes(0L, this.pageBuffer, 0, pageLength);
                            this.raf.seek(address);
                            this.raf.write(this.pageBuffer, 0, pageLength);
                        }
                        pte.dirty = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            private Memory freePage(int index) throws IOException {
                PageTableEntry pte;
                PageTableEntry pageTableEntry = pte = this.pageTable[index];
                synchronized (pageTableEntry) {
                    if (pte.memory == null) {
                        return null;
                    }
                    if (pte.refCount > 0) {
                        return null;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("evicting page in file " + pte.addressSpace.file.getPath() + " at address " + ((long)pte.index << (int)PAGE_BITS)));
                    }
                    if (pte.dirty) {
                        this.syncPage(index);
                    }
                    Memory ret = pte.memory;
                    pte.memory = null;
                    return ret;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Memory getPage(long address) {
                PageTableEntry pageTableEntry;
                PageTableEntry pageTableEntry2 = pageTableEntry = this.getPageTableEntry(address);
                synchronized (pageTableEntry2) {
                    ++pageTableEntry.requestsCounter;
                    Memory memory = pageTableEntry.memory;
                    if (memory != null) {
                        ++pageTableEntry.refCount;
                    }
                    return memory;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Memory getPageForWriting(long address) throws IOException {
                Memory ret;
                PageTableEntry pte;
                PageTableEntry pageTableEntry = pte = this.getPageTableEntry(address);
                synchronized (pageTableEntry) {
                    if (pte.memory != null) {
                        pte.dirty = true;
                        ++pte.refCount;
                        return pte.memory;
                    }
                }
                Memory freePage = MemoryManager.this.getFreePage();
                if (freePage == null) {
                    return null;
                }
                Object object = pte;
                synchronized (object) {
                    if (pte.memory == null) {
                        this.loadPage((int)(address >>> (int)PAGE_BITS), freePage);
                        pte.memory = freePage;
                        ret = freePage;
                    } else {
                        ret = pte.memory;
                    }
                    pte.dirty = true;
                    ++pte.refCount;
                }
                if (ret != freePage) {
                    object = MemoryManager.this.freePages;
                    synchronized (object) {
                        MemoryManager.this.freePages.add(freePage);
                    }
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void releasePage(long address) {
                PageTableEntry pte;
                PageTableEntry pageTableEntry = pte = this.getPageTableEntry(address);
                synchronized (pageTableEntry) {
                    --pte.refCount;
                }
            }

            public void incUsefulCount() {
                this.useful.incrementAndGet();
            }

            public void incTotalCount() {
                this.total.incrementAndGet();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sync() throws IOException {
                for (int i = 0; i < this.pageTable.length; ++i) {
                    PageTableEntry pte;
                    PageTableEntry pageTableEntry = pte = this.pageTable[i];
                    synchronized (pageTableEntry) {
                        if (pte.dirty) {
                            this.syncPage(i);
                        }
                        continue;
                    }
                }
                this.raf.getFD().sync();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    this.sync();
                }
                catch (Throwable throwable) {
                    PageTableEntry[] pageTableEntryArray = MemoryManager.this.addressSpaces;
                    synchronized (pageTableEntryArray) {
                        MemoryManager.this.addressSpaces.remove(this);
                    }
                    for (PageTableEntry pte : this.pageTable) {
                        Memory freePage;
                        Object object = pte;
                        synchronized (object) {
                            if (pte.memory != null) {
                                long address = (long)pte.index << (int)PAGE_BITS;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("evicting page in file " + this.file.getPath() + " at address " + address));
                                }
                                if (pte.dirty) {
                                    log.error((Object)("page in file " + this.file.getPath() + " at address " + address + " is dirty"));
                                }
                                if (pte.refCount > 0) {
                                    log.error((Object)("page in file " + this.file.getPath() + " at address " + address + " is still in use, refcount: " + pte.refCount));
                                }
                            }
                            freePage = pte.memory;
                            pte.memory = null;
                        }
                        if (freePage == null) continue;
                        object = MemoryManager.this.freePages;
                        synchronized (object) {
                            MemoryManager.this.freePages.add(freePage);
                        }
                    }
                    Closeables2.closeQuietly((Closeable)this.raf, (Logger)log);
                    throw throwable;
                }
                PageTableEntry[] pageTableEntryArray = MemoryManager.this.addressSpaces;
                synchronized (pageTableEntryArray) {
                    MemoryManager.this.addressSpaces.remove(this);
                }
                for (PageTableEntry pte : this.pageTable) {
                    Memory freePage;
                    Object object = pte;
                    synchronized (object) {
                        if (pte.memory != null) {
                            long address = (long)pte.index << (int)PAGE_BITS;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("evicting page in file " + this.file.getPath() + " at address " + address));
                            }
                            if (pte.dirty) {
                                log.error((Object)("page in file " + this.file.getPath() + " at address " + address + " is dirty"));
                            }
                            if (pte.refCount > 0) {
                                log.error((Object)("page in file " + this.file.getPath() + " at address " + address + " is still in use, refcount: " + pte.refCount));
                            }
                        }
                        freePage = pte.memory;
                        pte.memory = null;
                    }
                    if (freePage == null) continue;
                    object = MemoryManager.this.freePages;
                    synchronized (object) {
                        MemoryManager.this.freePages.add(freePage);
                    }
                }
                Closeables2.closeQuietly((Closeable)this.raf, (Logger)log);
            }
        }
    }

    public static class Reader<K>
    implements Closeable {
        private final MemoryManager.AddressSpace addressSpace;
        private final long size;
        private final Serializer<K> keySerializer;

        public Reader(MemoryManager memoryManager, File file, Serializer<K> keySerializer) throws IOException {
            this.keySerializer = keySerializer;
            this.size = file.length();
            this.addressSpace = memoryManager.openReadOnly(file, this.size);
        }

        public boolean contains(K key) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(out);
                this.keySerializer.write(key, (DataOutput)dataOut);
                byte[] bytes = out.toByteArray();
                int previousHash = -512093083;
                int loadedFilters = 0;
                for (int i = 0; i < 6; ++i) {
                    long hash = BloomFilter.getHash(bytes, previousHash);
                    previousHash = (int)hash;
                    long byteIndex = (hash %= this.size * 8L) >>> 3;
                    int bitIndex = (int)(hash & 7L);
                    Memory page = this.addressSpace.getPage(byteIndex);
                    if (page == null) continue;
                    ++loadedFilters;
                    int current = page.getByte(byteIndex & 0xFFFFL) & 0xFF;
                    this.addressSpace.releasePage(byteIndex);
                    if ((current & 1 << bitIndex) != 0) continue;
                    this.addressSpace.incUsefulCount();
                    this.addressSpace.incTotalCount();
                    return false;
                }
                if (loadedFilters == 6) {
                    this.addressSpace.incTotalCount();
                }
                return true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            this.addressSpace.close();
        }

        public long sizeInBytes() {
            return this.size;
        }
    }

    public static class Writer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <K> void write(MemoryManager memoryManager, File file, Iterator<? extends Generation.Entry<K, ?>> iterator, Serializer<K> keySerializer, long size) throws IOException, NotEnoughMemoryException {
            MemoryManager.AddressSpace addressSpace = memoryManager.open(file, size);
            Memory[] pages = new Memory[(int)(size - 1L >> (int)PAGE_BITS) + 1];
            long pageIndex = 0L;
            try {
                for (pageIndex = 0L; pageIndex < size; pageIndex += 65536L) {
                    Memory page = addressSpace.getPageForWriting(pageIndex);
                    if (page == null) {
                        throw new NotEnoughMemoryException("insufficient memory available to write bloom filter, allocated " + pageIndex + " bytes before failing");
                    }
                    pages[(int)(pageIndex >>> (int)PAGE_BITS)] = page;
                }
            }
            catch (Throwable t) {
                for (long j = 0L; j < pageIndex; j += 65536L) {
                    addressSpace.releasePage(j);
                }
                addressSpace.close();
                Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
                Throwables.propagateIfInstanceOf((Throwable)t, NotEnoughMemoryException.class);
                throw Throwables.propagate((Throwable)t);
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(out);
                while (iterator.hasNext()) {
                    Generation.Entry<K, ?> next = iterator.next();
                    K key = next.getKey();
                    out.reset();
                    keySerializer.write(key, (DataOutput)dataOut);
                    byte[] bytes = out.toByteArray();
                    int previousHash = -512093083;
                    for (int i = 0; i < 6; ++i) {
                        long hash = BloomFilter.getHash(bytes, previousHash);
                        previousHash = (int)hash;
                        long byteIndex = (hash %= size * 8L) >>> 3;
                        int bitIndex = (int)(hash & 7L);
                        Memory memory = pages[(int)(byteIndex >>> (int)PAGE_BITS)];
                        int current = memory.getByte(byteIndex & 0xFFFFL) & 0xFF;
                        memory.putByte(byteIndex & 0xFFFFL, (byte)(current |= 1 << bitIndex));
                    }
                }
            }
            finally {
                for (long i = 0L; i < size; i += 65536L) {
                    addressSpace.releasePage(i);
                }
                addressSpace.close();
            }
        }
    }

    public static final class NotEnoughMemoryException
    extends Exception {
        public NotEnoughMemoryException(String message) {
            super(message);
        }
    }
}

