/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import fj.F;
import fj.F2;
import fj.P2;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class ItUtil {
    public static <A> Iterable<A> iterable(final Iterator<A> it) {
        return new Iterable<A>(){
            boolean used = false;

            @Override
            public Iterator<A> iterator() {
                if (this.used) {
                    throw new IllegalStateException("iterator may not be called more than once");
                }
                this.used = true;
                return it;
            }
        };
    }

    public static <A> Iterable<A> iterable(Iterator<A> it, boolean reusable) {
        if (reusable) {
            ArrayList<A> ret = new ArrayList<A>();
            for (A t : ItUtil.iterable(it)) {
                ret.add(t);
            }
            return ret;
        }
        return ItUtil.iterable(it);
    }

    public static <A, B> Iterator<B> map(final F<A, B> f, final Iterator<A> it) {
        return new AbstractIterator<B>(){

            protected B computeNext() {
                if (it.hasNext()) {
                    return f.f(it.next());
                }
                this.endOfData();
                return null;
            }
        };
    }

    public static <A, B> Iterable<B> map(final F<A, B> f, final Iterable<A> it) {
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return ItUtil.map(f, it.iterator());
            }
        };
    }

    public static <A> Iterator<A> filter(final F<A, Boolean> f, final Iterator<A> it) {
        return new AbstractIterator<A>(){

            protected A computeNext() {
                while (it.hasNext()) {
                    Object a = it.next();
                    if (!((Boolean)f.f(a)).booleanValue()) continue;
                    return a;
                }
                this.endOfData();
                return null;
            }
        };
    }

    public static <A> Iterable<A> filter(final F<A, Boolean> f, final Iterable<A> it) {
        return new Iterable<A>(){

            @Override
            public Iterator<A> iterator() {
                return ItUtil.filter(f, it.iterator());
            }
        };
    }

    public static <A, B> B fold(F2<B, A, B> f, B initial, Iterable<A> it) {
        Object b = initial;
        for (A a : it) {
            b = f.f(b, a);
        }
        return b;
    }

    public static <A, B> B fold(F2<B, A, B> f, B initial, Iterator<A> it) {
        return ItUtil.fold(f, initial, ItUtil.iterable(it));
    }

    public static <A> P2<Iterator<A>, Iterator<A>> span(final F<A, Boolean> f, final Iterator<A> it) {
        return new P2<Iterator<A>, Iterator<A>>(){
            PeekingIterator<A> peekingIterator;
            boolean firstDone;
            Iterator<A> first;
            Iterator<A> second;
            {
                this.peekingIterator = Iterators.peekingIterator((Iterator)it);
                this.firstDone = false;
                this.first = new AbstractIterator<A>(){

                    protected A computeNext() {
                        if (firstDone) {
                            throw new IllegalStateException("cannot access first iterator after second has been accessed");
                        }
                        if (peekingIterator.hasNext() && ((Boolean)f.f(peekingIterator.peek())).booleanValue()) {
                            return peekingIterator.next();
                        }
                        this.endOfData();
                        firstDone = true;
                        return null;
                    }
                };
                this.second = new AbstractIterator<A>(){

                    protected A computeNext() {
                        if (!firstDone) {
                            while (first.hasNext()) {
                                first.next();
                            }
                            firstDone = true;
                        }
                        if (peekingIterator.hasNext()) {
                            return peekingIterator.next();
                        }
                        this.endOfData();
                        return null;
                    }
                };
            }

            public Iterator<A> _1() {
                return this.first;
            }

            public Iterator<A> _2() {
                return this.second;
            }
        };
    }

    public static <A> P2<Iterator<A>, Iterator<A>> span(F<A, Boolean> f, Iterable<A> it) {
        return ItUtil.span(f, it.iterator());
    }

    public static <A> Iterator<Iterator<A>> groupBy(final F2<A, A, Boolean> f, final Iterator<A> iterator) {
        return new AbstractIterator<Iterator<A>>(){
            PeekingIterator<A> it;
            InvalidatableIterator<A> prev;
            {
                this.it = Iterators.peekingIterator((Iterator)iterator);
                this.prev = null;
            }

            protected Iterator<A> computeNext() {
                if (this.it.hasNext()) {
                    if (this.prev != null) {
                        while (this.prev.hasNext()) {
                            this.prev.next();
                        }
                        this.prev.invalidate();
                    }
                    this.prev = new InvalidatableIterator<A>(){
                        A a;
                        boolean initialized = false;

                        @Override
                        protected A computeNext1() {
                            if (!this.initialized) {
                                this.a = it.next();
                                this.initialized = true;
                                return this.a;
                            }
                            if (it.hasNext() && ((Boolean)f.f(this.a, it.peek())).booleanValue()) {
                                this.a = it.next();
                                return this.a;
                            }
                            this.endOfData();
                            return null;
                        }
                    };
                    return this.prev;
                }
                this.endOfData();
                return null;
            }
        };
    }

    public static <A> Iterator<Iterator<A>> groupBy(F2<A, A, Boolean> f, Iterable<A> it) {
        return ItUtil.groupBy(f, it.iterator());
    }

    public static <A> Iterator<A> intersperse(final A a, final Iterator<A> it) {
        return new AbstractIterator<A>(){
            boolean b = false;

            protected A computeNext() {
                if (it.hasNext()) {
                    if (this.b) {
                        this.b = false;
                        return a;
                    }
                    this.b = true;
                    return it.next();
                }
                this.endOfData();
                return null;
            }
        };
    }

    public static <A> Iterable<A> intersperse(final A a, final Iterable<A> it) {
        return new Iterable<A>(){

            @Override
            public Iterator<A> iterator() {
                return ItUtil.intersperse(a, it.iterator());
            }
        };
    }

    public static <A> Iterator<A> intercalate(Iterator<A> a, Iterator<Iterator<A>> it) {
        return Iterables.concat(ItUtil.intersperse(ItUtil.iterable(a, true), ItUtil.iterable(ItUtil.map(new F<Iterator<A>, Iterable<A>>(){

            public Iterable<A> f(Iterator<A> aIterator) {
                return ItUtil.iterable(aIterator);
            }
        }, it)))).iterator();
    }

    public static <A> Iterator<Iterator<A>> partition(final Iterator<A> a, final int count) {
        return new AbstractIterator<Iterator<A>>(){

            protected Iterator<A> computeNext() {
                return new AbstractIterator<A>(){
                    int c = 0;

                    protected A computeNext() {
                        if (this.c == count || !a.hasNext()) {
                            this.endOfData();
                            return null;
                        }
                        return a.next();
                    }
                };
            }
        };
    }

    public static <A> Iterable<Iterable<A>> partition(final Iterable<A> a, final int count) {
        return new Iterable<Iterable<A>>(){

            @Override
            public Iterator<Iterable<A>> iterator() {
                final Iterator it = a.iterator();
                return new AbstractIterator<Iterable<A>>(){

                    protected Iterable<A> computeNext() {
                        if (it.hasNext()) {
                            return new Iterable<A>(){

                                @Override
                                public Iterator<A> iterator() {
                                    return new AbstractIterator<A>(){
                                        int c = 0;

                                        protected A computeNext() {
                                            if (this.c == count || !it.hasNext()) {
                                                this.endOfData();
                                                return null;
                                            }
                                            return it.next();
                                        }
                                    };
                                }
                            };
                        }
                        this.endOfData();
                        return null;
                    }
                };
            }
        };
    }

    public static <E> Iterator<E> merge(Collection<Iterator<E>> iterators, final Comparator<E> comparator) {
        Comparator heapComparator = new Comparator<PeekingIterator<E>>(){

            @Override
            public int compare(PeekingIterator<E> o1, PeekingIterator<E> o2) {
                return comparator.compare(o1.peek(), o2.peek());
            }
        };
        final ObjectHeapPriorityQueue heap = new ObjectHeapPriorityQueue(heapComparator);
        for (Iterator<E> iterator : iterators) {
            if (!iterator.hasNext()) continue;
            if (iterator instanceof PeekingIterator) {
                heap.enqueue((Object)((PeekingIterator)iterator));
                continue;
            }
            heap.enqueue((Object)Iterators.peekingIterator(iterator));
        }
        return new AbstractIterator<E>(){

            protected E computeNext() {
                if (heap.isEmpty()) {
                    this.endOfData();
                    return null;
                }
                PeekingIterator iterator = (PeekingIterator)heap.first();
                Object ret = iterator.next();
                if (iterator.hasNext()) {
                    heap.changed();
                } else {
                    heap.dequeue();
                }
                return ret;
            }
        };
    }

    public static void main(String[] args) {
        Integer[] ints = new Integer[]{1, 1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 10, 11};
        List<Integer> intList = Arrays.asList(ints);
        Iterator<Iterator<Integer>> it = ItUtil.groupBy(new F2<Integer, Integer, Boolean>(){

            public Boolean f(Integer integer, Integer integer1) {
                return integer.equals(integer1);
            }
        }, intList);
        F<Iterator<Integer>, String> concat = new F<Iterator<Integer>, String>(){

            public String f(Iterator<Integer> integerIterator) {
                return ItUtil.fold(new F2<String, String, String>(){

                    public String f(String s, String s1) {
                        return s + s1;
                    }
                }, "", ItUtil.intersperse(", ", ItUtil.map(new F<Integer, String>(){

                    public String f(Integer integer) {
                        return String.valueOf(integer);
                    }
                }, integerIterator)));
            }
        };
        for (Iterator<Integer> it1 : ItUtil.iterable(it)) {
            System.out.println((String)concat.f(it1));
        }
        P2<Iterator<Integer>, Iterator<Integer>> p = ItUtil.span(new F<Integer, Boolean>(){

            public Boolean f(Integer integer) {
                return integer < 5;
            }
        }, intList);
        System.out.println((String)concat.f(p._2()));
        Iterable<Integer> it2 = ItUtil.filter(new F<Integer, Boolean>(){

            public Boolean f(Integer integer) {
                return integer % 2 == 0;
            }
        }, intList);
        System.out.println((String)concat.f(it2.iterator()));
    }

    private static abstract class InvalidatableIterator<E>
    extends AbstractIterator<E> {
        private boolean invalid = false;

        private InvalidatableIterator() {
        }

        public final void invalidate() {
            this.invalid = true;
        }

        protected final E computeNext() {
            if (this.invalid) {
                throw new IllegalStateException("iterator has been invalidated");
            }
            return this.computeNext1();
        }

        protected abstract E computeNext1();
    }
}

