/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.io.Closer;
import com.indeed.lsmtree.recordlog.BasicRecordFile;
import com.indeed.lsmtree.recordlog.RecordFile;
import com.indeed.util.serialization.Serializer;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class TransactionLog {
    private static final Logger log = Logger.getLogger(TransactionLog.class);

    public static class LogClosedException
    extends Exception {
    }

    private static final class OpKeyValueSerialzer<K, V>
    implements Serializer<OpKeyValue<K, V>> {
        Serializer<K> keySerializer;
        Serializer<V> valueSerializer;

        private OpKeyValueSerialzer(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        public void write(OpKeyValue<K, V> kvOpKeyValue, DataOutput out) throws IOException {
            out.writeByte(kvOpKeyValue.type.getTransactionTypeId());
            this.keySerializer.write(kvOpKeyValue.key, out);
            if (kvOpKeyValue.type == TransactionType.PUT) {
                this.valueSerializer.write(kvOpKeyValue.value, out);
            }
        }

        public OpKeyValue<K, V> read(DataInput in) throws IOException {
            TransactionType type = TransactionType.getTransactionType(in.readByte());
            Object key = this.keySerializer.read(in);
            Object value = null;
            if (type == TransactionType.PUT) {
                value = this.valueSerializer.read(in);
            }
            return new OpKeyValue(type, key, value);
        }
    }

    private static final class OpKeyValue<K, V> {
        TransactionType type;
        K key;
        V value;

        private OpKeyValue(TransactionType type, K key, @Nullable V value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }
    }

    public static enum TransactionType {
        PUT(1),
        DELETE(2);

        int transactionTypeId;

        public int getTransactionTypeId() {
            return this.transactionTypeId;
        }

        private TransactionType(int transactionTypeId) {
            this.transactionTypeId = transactionTypeId;
        }

        public static TransactionType getTransactionType(int transactionTypeId) {
            switch (transactionTypeId) {
                case 1: {
                    return PUT;
                }
                case 2: {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException(transactionTypeId + " is not a valid transactionTypeId");
        }
    }

    public static class Writer<K, V>
    implements Closeable {
        private final BasicRecordFile.Writer<OpKeyValue<K, V>> writer;
        private boolean sync;
        private boolean isClosed = false;
        private long sizeInBytes = 0L;

        public Writer(File file, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this(file, keySerializer, valueSerializer, true);
        }

        public Writer(File file, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean sync) throws IOException {
            this.sync = sync;
            this.writer = new BasicRecordFile.Writer(file, new OpKeyValueSerialzer(keySerializer, valueSerializer));
        }

        public synchronized void put(K key, V value) throws IOException, LogClosedException {
            if (this.isClosed) {
                throw new LogClosedException();
            }
            try {
                this.sizeInBytes = this.writer.append(new OpKeyValue(TransactionType.PUT, key, value));
                if (this.sync) {
                    this.writer.sync();
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }

        public synchronized void delete(K key) throws IOException, LogClosedException {
            if (this.isClosed) {
                throw new LogClosedException();
            }
            try {
                this.sizeInBytes = this.writer.append(new OpKeyValue(TransactionType.DELETE, key, null));
                if (this.sync) {
                    this.writer.sync();
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.isClosed) {
                IOException exception = null;
                try {
                    this.writer.sync();
                }
                catch (IOException e) {
                    exception = e;
                }
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    exception = e;
                }
                this.isClosed = true;
                if (exception != null) {
                    throw exception;
                }
            }
        }

        public synchronized long sizeInBytes() throws IOException {
            return this.sizeInBytes;
        }

        public synchronized void sync() throws IOException {
            try {
                if (!this.isClosed) {
                    this.writer.sync();
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    public static class Reader<K, V>
    implements Closeable {
        private final BasicRecordFile<OpKeyValue<K, V>> recordFile;
        private final RecordFile.Reader<OpKeyValue<K, V>> reader;
        private boolean done;
        private TransactionType type;
        private K key;
        private V value;

        public Reader(File path, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this.recordFile = new BasicRecordFile(path, new OpKeyValueSerialzer(keySerializer, valueSerializer));
            this.reader = this.recordFile.reader();
        }

        public boolean next() throws IOException {
            if (this.done) {
                return false;
            }
            try {
                if (!this.reader.next()) {
                    this.done = true;
                    return false;
                }
            }
            catch (IOException e) {
                log.warn((Object)"error reading log file, halting log replay at this point", (Throwable)e);
                this.done = true;
                return false;
            }
            OpKeyValue opKeyValue = (OpKeyValue)this.reader.get();
            this.type = opKeyValue.type;
            this.key = opKeyValue.key;
            if (this.type == TransactionType.PUT) {
                this.value = opKeyValue.value;
            }
            return true;
        }

        public TransactionType getType() {
            return this.type;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public void close() throws IOException {
            Closer closer = Closer.create();
            closer.register(this.reader);
            closer.register(this.recordFile);
            closer.close();
        }
    }
}

