/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.indeed.lsmtree.core.BloomFilter;
import com.indeed.lsmtree.core.Generation;
import com.indeed.lsmtree.core.MergingIterator;
import com.indeed.lsmtree.core.RuntimeIOException;
import com.indeed.lsmtree.core.StableGeneration;
import com.indeed.lsmtree.core.StorageType;
import com.indeed.lsmtree.core.TransactionLog;
import com.indeed.lsmtree.core.VolatileGeneration;
import com.indeed.lsmtree.core.iteratee.Enumerator;
import com.indeed.lsmtree.core.iteratee.Input;
import com.indeed.lsmtree.core.iteratee.Iteratee;
import com.indeed.lsmtree.core.iteratee.Processor;
import com.indeed.util.compress.CompressionCodec;
import com.indeed.util.core.io.Closeables2;
import com.indeed.util.core.reference.AtomicSharedReference;
import com.indeed.util.core.reference.SharedReference;
import com.indeed.util.core.shell.PosixFileOperations;
import com.indeed.util.mmap.NativeFileUtils;
import com.indeed.util.serialization.Serializer;
import fj.F2;
import fj.P;
import fj.P4;
import fj.data.Stream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public final class Store<K, V>
implements Closeable {
    private static final Logger log = Logger.getLogger(Store.class);
    private final AtomicSharedReference<GenerationState<K, V>> generationState;
    private final File root;
    private final File dataDir;
    private final AtomicLong lastUsedTimeStamp;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final Ordering<K> comparator;
    private final long maxVolatileGenerationSize;
    private final Compactor compactor;
    private final File lockFile;
    private final StorageType storageType;
    private final CompressionCodec codec;
    private final AtomicLong totalGenerationSpace = new AtomicLong(0L);
    private final AtomicLong reservedCompactionSpace = new AtomicLong(0L);
    private final long reservedSpaceThreshold;
    private final boolean mlockFiles;
    private final boolean dedicatedPartition;
    private boolean closed = false;
    private final BloomFilter.MemoryManager memoryManager;
    private final F2<GenerationState<K, V>, K, V> get = new F2<GenerationState<K, V>, K, V>(){

        @Nullable
        public V f(GenerationState<K, V> localState, K key) {
            Generation.Entry getResult = localState.volatileGeneration.get(key);
            if (getResult != null) {
                if (getResult.isDeleted()) {
                    return null;
                }
                return getResult.getValue();
            }
            for (Generation stableGeneration : localState.stableGenerations) {
                getResult = stableGeneration.get(key);
                if (getResult == null) continue;
                if (getResult.isDeleted()) {
                    return null;
                }
                return getResult.getValue();
            }
            return null;
        }
    };
    private final F2<GenerationState<K, V>, K, Boolean> containsKey = new F2<GenerationState<K, V>, K, Boolean>(){

        public Boolean f(GenerationState<K, V> localState, K key) {
            Boolean isDeleted = localState.volatileGeneration.isDeleted(key);
            if (isDeleted != null) {
                return isDeleted != Boolean.TRUE;
            }
            for (Generation stableGeneration : localState.stableGenerations) {
                isDeleted = stableGeneration.isDeleted(key);
                if (isDeleted == null) continue;
                return isDeleted != Boolean.TRUE;
            }
            return false;
        }
    };
    private final F2<GenerationState<K, V>, Entry<K, V>, Boolean> put = new F2<GenerationState<K, V>, Entry<K, V>, Boolean>(){

        public Boolean f(GenerationState<K, V> localState, Entry<K, V> keyValue) {
            try {
                try {
                    localState.volatileGeneration.put(keyValue.getKey(), keyValue.getValue());
                }
                catch (IOException e) {
                    Store.this.compactor.compact();
                    throw e;
                }
                if (localState.volatileGeneration.sizeInBytes() > Store.this.maxVolatileGenerationSize) {
                    Store.this.compactor.compact();
                }
                return true;
            }
            catch (TransactionLog.LogClosedException e) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    };
    private final F2<GenerationState<K, V>, K, Boolean> delete = new F2<GenerationState<K, V>, K, Boolean>(){

        public Boolean f(GenerationState localState, Object key) {
            try {
                try {
                    localState.volatileGeneration.delete(key);
                }
                catch (IOException e) {
                    Store.this.compactor.compact();
                    throw e;
                }
                if (localState.volatileGeneration.sizeInBytes() > Store.this.maxVolatileGenerationSize) {
                    Store.this.compactor.compact();
                }
                return true;
            }
            catch (TransactionLog.LogClosedException e) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    };
    private final Process process = new Process();
    private final F2<GenerationState<K, V>, Object, Long> getActiveSpaceUsage = new F2<GenerationState<K, V>, Object, Long>(){

        public Long f(GenerationState<K, V> state, Object o) {
            try {
                long spaceUsage = state.volatileGeneration.sizeInBytes();
                for (Generation generation : state.stableGenerations) {
                    spaceUsage += generation.sizeInBytes();
                }
                return spaceUsage;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    };
    private final F2<GenerationState<K, V>, Object, Long> getTotalSpaceUsage = new F2<GenerationState<K, V>, Object, Long>(){

        public Long f(GenerationState<K, V> state, Object o) {
            try {
                return Store.this.totalGenerationSpace.get() + state.volatileGeneration.sizeInBytes();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    };

    Store(File root, Serializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator, long maxVolatileGenerationSize, StorageType storageType, CompressionCodec codec, boolean readOnly, boolean dedicatedPartition, long reservedSpaceThreshold, boolean mlockFiles, long bloomFilterMemory, boolean mlockBloomFilters) throws IOException {
        this.storageType = storageType;
        this.codec = codec;
        this.dedicatedPartition = dedicatedPartition;
        this.reservedSpaceThreshold = reservedSpaceThreshold;
        this.mlockFiles = mlockFiles;
        if (!root.isDirectory() && !root.mkdirs()) {
            String err = root.getAbsolutePath() + " could not be created";
            log.error((Object)err);
            throw new IOException(err);
        }
        if (!readOnly) {
            File lockFileLock = new File(root, "write.lock.lock");
            try {
                Integer pid;
                if (!lockFileLock.createNewFile()) {
                    throw new IOException(lockFileLock.getAbsolutePath() + " is already locked");
                }
                File lockFile = new File(root, "write.lock");
                if (lockFile.exists() && ((pid = PosixFileOperations.tryParseInt((String)Files.toString((File)lockFile, (Charset)Charsets.UTF_8))) == null || PosixFileOperations.isProcessRunning((int)pid, (boolean)true))) {
                    lockFileLock.delete();
                    throw new IOException(lockFile.getAbsolutePath() + " is already locked");
                }
                Files.write((CharSequence)String.valueOf(PosixFileOperations.getPID()), (File)lockFile, (Charset)Charsets.UTF_8);
                lockFileLock.delete();
                this.lockFile = lockFile;
                this.lockFile.deleteOnExit();
            }
            catch (IOException e) {
                log.error((Object)("problem locking lsmtree in directory " + root.getAbsolutePath()), (Throwable)e);
                throw e;
            }
        } else {
            this.lockFile = null;
        }
        this.root = root;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.comparator = Ordering.from(comparator);
        this.maxVolatileGenerationSize = maxVolatileGenerationSize;
        this.generationState = AtomicSharedReference.create();
        this.dataDir = new File(root, "data");
        ArrayList<Generation<K, V>> stableGenerations = new ArrayList<Generation<K, V>>();
        ArrayList<File> toDelete = new ArrayList<File>();
        this.lastUsedTimeStamp = new AtomicLong();
        this.memoryManager = new BloomFilter.MemoryManager(bloomFilterMemory, mlockBloomFilters);
        try {
            GenerationState nextState;
            VolatileGeneration<K, V> nextVolatileGeneration;
            if (!this.dataDir.exists()) {
                this.dataDir.mkdirs();
                File newLog = this.getNextLogFile();
                nextVolatileGeneration = new VolatileGeneration<K, V>(newLog, keySerializer, valueSerializer, comparator);
            } else {
                long maxTimestamp = 0L;
                maxTimestamp = this.findMaxTimestamp(root, maxTimestamp);
                maxTimestamp = this.findMaxTimestamp(this.dataDir, maxTimestamp);
                this.lastUsedTimeStamp.set(maxTimestamp);
                File latestDir = new File(root, "latest");
                File file = new File(latestDir, "state");
                Yaml yaml = new Yaml();
                InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
                Map map = (Map)yaml.load((Reader)reader);
                Closeables2.closeQuietly((Closeable)reader, (Logger)log);
                File volatileGenerationFile = new File(latestDir, (String)map.get("volatileGeneration"));
                final List oldStableGenerations = (List)map.get("stableGenerations");
                if (readOnly) {
                    nextVolatileGeneration = new VolatileGeneration<K, V>(volatileGenerationFile, keySerializer, valueSerializer, comparator, true);
                    for (String generationName : oldStableGenerations) {
                        File generationFile = new File(latestDir, generationName);
                        if (generationName.endsWith(".log")) {
                            stableGenerations.add(new VolatileGeneration<K, V>(this.getDataFile(generationFile), keySerializer, valueSerializer, comparator, true));
                            continue;
                        }
                        stableGenerations.add(StableGeneration.open(this.memoryManager, this.getDataFile(generationFile), comparator, keySerializer, valueSerializer, storageType, codec, mlockFiles));
                    }
                } else {
                    Collections.addAll(toDelete, this.dataDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return !oldStableGenerations.contains(name);
                        }
                    }));
                    Collections.addAll(toDelete, root.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory() && pathname.getName().matches("\\d+");
                        }
                    }));
                    File newLog = this.getNextLogFile();
                    nextVolatileGeneration = new VolatileGeneration<K, V>(newLog, keySerializer, valueSerializer, comparator);
                    nextVolatileGeneration.replayTransactionLog(volatileGenerationFile);
                    for (String generationName : oldStableGenerations) {
                        File generationFile = new File(latestDir, generationName);
                        if (generationName.endsWith(".log")) {
                            File tempLog = this.getNextLogFile();
                            VolatileGeneration<K, V> temp = new VolatileGeneration<K, V>(tempLog, keySerializer, valueSerializer, comparator);
                            temp.replayTransactionLog(generationFile);
                            stableGenerations.add(this.doCompaction(Collections.singletonList(temp), true));
                            temp.delete();
                            toDelete.add(this.getDataFile(generationFile));
                            continue;
                        }
                        stableGenerations.add(StableGeneration.open(this.memoryManager, this.getDataFile(generationFile), comparator, keySerializer, valueSerializer, storageType, codec, mlockFiles));
                    }
                }
            }
            ArrayList stableGenerationReferences = Lists.newArrayList();
            for (Generation generation : stableGenerations) {
                stableGenerationReferences.add(SharedReference.create((Closeable)generation));
            }
            if (!readOnly) {
                File checkpointDir = this.getNextCheckpointDir();
                checkpointDir.mkdirs();
                nextState = new GenerationState(stableGenerationReferences, SharedReference.create(nextVolatileGeneration), checkpointDir);
                this.checkpointGenerationState(nextState, checkpointDir);
                PosixFileOperations.atomicLink((File)checkpointDir, (File)new File(root, "latest"));
            } else {
                nextState = new GenerationState(stableGenerationReferences, SharedReference.create(nextVolatileGeneration), this.getDataFile(new File(root, "latest")));
            }
            this.generationState.set(nextState);
            for (Generation generation : nextState.stableGenerations) {
                this.totalGenerationSpace.addAndGet(generation.sizeInBytes());
            }
            if (!readOnly) {
                this.compactor = new Compactor();
                for (File file : toDelete) {
                    log.info((Object)("deleting " + file.getPath()));
                    if (file.isDirectory()) {
                        PosixFileOperations.rmrf((File)file);
                        continue;
                    }
                    file.delete();
                }
            } else {
                if (!toDelete.isEmpty()) {
                    log.error((Object)"toDelete should be empty");
                }
                this.compactor = null;
            }
        }
        catch (Throwable t) {
            this.memoryManager.close();
            Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private File getDataFile(File file) {
        return new File(this.dataDir, file.getName());
    }

    private long findMaxTimestamp(File dir, long maxTimestamp) {
        for (String str : dir.list()) {
            long timestamp = 0L;
            if (str.matches("\\d+")) {
                timestamp = Long.parseLong(str);
            } else if (str.matches("\\d+\\.log")) {
                timestamp = Long.parseLong(str.substring(0, str.length() - 4));
            }
            if (timestamp <= maxTimestamp) continue;
            maxTimestamp = timestamp;
        }
        return maxTimestamp;
    }

    private <A, B> A doWithState(F2<GenerationState<K, V>, B, A> function, @Nullable B b) throws IOException {
        SharedReference localState = this.generationState.getCopy();
        try {
            if (localState == null) {
                throw new IOException("store is closed");
            }
            Object object = function.f(localState.get(), b);
            return (A)object;
        }
        catch (RuntimeIOException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
            log.error((Object)"RuntimeIOException inner exception is not IOException", (Throwable)e);
            throw Throwables.propagate((Throwable)e.getCause());
        }
        finally {
            Closeables2.closeQuietly((Closeable)localState, (Logger)log);
        }
    }

    private <B> void doUntilSuccessful(F2<GenerationState<K, V>, B, Boolean> function, B b) throws IOException {
        while (!this.doWithState(function, b).booleanValue()) {
        }
    }

    @Nullable
    public V get(K key) throws IOException {
        return this.doWithState(this.get, key);
    }

    public boolean containsKey(K key) throws IOException {
        return this.doWithState(this.containsKey, key);
    }

    public void put(K key, V value) throws IOException {
        this.doUntilSuccessful(this.put, new Entry<K, V>(key, value));
    }

    public void delete(K key) throws IOException {
        this.doUntilSuccessful(this.delete, key);
    }

    private static <K, V> MergingIterator<K, V> getMergedIterator(GenerationState<K, V> state, Function<Generation<K, V>, Iterator<Generation.Entry<K, V>>> f, Comparator<K> comp) {
        ArrayList generations = Lists.newArrayList();
        generations.add(((GenerationState)state).volatileGeneration);
        generations.addAll(((GenerationState)state).stableGenerations);
        return new MergingIterator(Lists.transform((List)generations, f), comp);
    }

    @Nullable
    private static <K, V> Entry<K, V> getFirstNotDeleted(Iterator<Generation.Entry<K, V>> iterator) {
        while (iterator.hasNext()) {
            Generation.Entry<K, V> next = iterator.next();
            if (next.isDeleted()) continue;
            return new Entry<K, V>(next.getKey(), next.getValue());
        }
        return null;
    }

    private F2<GenerationState<K, V>, K, Entry<K, V>> neighbor(final boolean reverse, final boolean inclusive) {
        return new F2<GenerationState<K, V>, K, Entry<K, V>>(){

            @Nullable
            public Entry<K, V> f(GenerationState<K, V> kvGenerationState, final K k) {
                MergingIterator iterator = Store.getMergedIterator(kvGenerationState, new Function<Generation<K, V>, Iterator<Generation.Entry<K, V>>>(){

                    public Iterator<Generation.Entry<K, V>> apply(Generation<K, V> input) {
                        if (k == null) {
                            return reverse ? input.reverseIterator() : input.iterator();
                        }
                        return reverse ? input.reverseIterator(k, inclusive) : input.iterator(k, inclusive);
                    }
                }, (Comparator)(reverse ? Store.this.comparator.reverse() : Store.this.comparator));
                return Store.getFirstNotDeleted((Iterator)((Object)iterator));
            }
        };
    }

    @Nullable
    public Entry<K, V> lower(K key) throws IOException {
        return this.doWithState(this.neighbor(true, false), key);
    }

    @Nullable
    public Entry<K, V> floor(K key) throws IOException {
        return this.doWithState(this.neighbor(true, true), key);
    }

    @Nullable
    public Entry<K, V> ceil(K key) throws IOException {
        return this.doWithState(this.neighbor(false, true), key);
    }

    @Nullable
    public Entry<K, V> higher(K key) throws IOException {
        return this.doWithState(this.neighbor(false, false), key);
    }

    @Nullable
    public Entry<K, V> first() throws IOException {
        return this.doWithState(this.neighbor(false, false), null);
    }

    @Nullable
    public Entry<K, V> last() throws IOException {
        return this.doWithState(this.neighbor(true, false), null);
    }

    public Iterator<Entry<K, V>> iterator() throws IOException {
        return this.iterator(null, false, false);
    }

    public Iterator<Entry<K, V>> iterator(K start, boolean inclusive) throws IOException {
        return this.iterator(start, inclusive, false);
    }

    public Iterator<Entry<K, V>> reverseIterator() throws IOException {
        return this.iterator(null, false, true);
    }

    public Iterator<Entry<K, V>> reverseIterator(K start, boolean inclusive) throws IOException {
        return this.iterator(start, inclusive, true);
    }

    public Iterator<Entry<K, V>> iterator(final @Nullable K start, final boolean inclusive, final boolean reverse) throws IOException {
        return new Iterator<Entry<K, V>>(){
            Deque<Entry<K, V>> buffer;
            Processor<Entry<K, V>, Deque<Entry<K, V>>> processor = new Processor<Entry<K, V>, Deque<Entry<K, V>>>(){
                final Input.Matcher<Entry<K, V>, Iteratee<Entry<K, V>, Deque<Entry<K, V>>>> matcher = new Input.Matcher<Entry<K, V>, Iteratee<Entry<K, V>, Deque<Entry<K, V>>>>(){

                    @Override
                    public Iteratee<Entry<K, V>, Deque<Entry<K, V>>> eof() {
                        return this.Done(buffer);
                    }

                    @Override
                    public Iteratee<Entry<K, V>, Deque<Entry<K, V>>> empty() {
                        return this.Cont();
                    }

                    @Override
                    public Iteratee<Entry<K, V>, Deque<Entry<K, V>>> element(Entry<K, V> kvEntry) {
                        buffer.add(kvEntry);
                        if (buffer.size() >= 1000) {
                            return this.Done(buffer);
                        }
                        return this.Cont();
                    }
                };

                @Override
                public Iteratee<Entry<K, V>, Deque<Entry<K, V>>> process(Input<Entry<K, V>> input) {
                    return input.match(this.matcher);
                }
            };
            {
                this.buffer = new ArrayDeque(1000);
                if (start == null) {
                    Store.this.process(this.processor, reverse);
                } else {
                    Store.this.process(this.processor, start, inclusive, reverse);
                }
            }

            @Override
            public boolean hasNext() {
                return !this.buffer.isEmpty();
            }

            @Override
            public Entry<K, V> next() {
                Entry ret = this.buffer.removeFirst();
                if (this.buffer.isEmpty()) {
                    try {
                        Store.this.process(this.processor, ret.getKey(), false, reverse);
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public <A> A process(Processor<Entry<K, V>, A> processor) throws IOException {
        return this.doWithState(this.process(), P.p(processor, (Object)null, (Object)Boolean.FALSE, (Object)Boolean.FALSE));
    }

    public <A> A process(Processor<Entry<K, V>, A> processor, boolean reverse) throws IOException {
        return this.doWithState(this.process(), P.p(processor, (Object)null, (Object)Boolean.FALSE, (Object)reverse));
    }

    public <A> A process(Processor<Entry<K, V>, A> processor, K start, boolean inclusive, boolean reverse) throws IOException {
        return this.doWithState(this.process(), P.p(processor, start, (Object)inclusive, (Object)reverse));
    }

    private <A> Process<A> process() {
        return this.process;
    }

    private Stream<Entry<K, V>> stream(final GenerationState<K, V> state, final K start, final boolean inclusive, final boolean reverse) {
        return Stream.iterableStream((Iterable)new Iterable<Entry<K, V>>(){

            @Override
            public Iterator<Entry<K, V>> iterator() {
                return new AbstractIterator<Entry<K, V>>(){
                    Iterator<Generation.Entry<K, V>> iterator;
                    {
                        this.iterator = Store.getMergedIterator(state, new Function<Generation<K, V>, Iterator<Generation.Entry<K, V>>>(){

                            public Iterator<Generation.Entry<K, V>> apply(Generation<K, V> input) {
                                if (reverse) {
                                    return start == null ? input.reverseIterator() : input.reverseIterator(start, inclusive);
                                }
                                return start == null ? input.iterator() : input.iterator(start, inclusive);
                            }
                        }, (Comparator)(reverse ? Store.this.comparator.reverse() : Store.this.comparator));
                    }

                    protected Entry<K, V> computeNext() {
                        while (this.iterator.hasNext()) {
                            Generation.Entry next = this.iterator.next();
                            if (next.isDeleted()) continue;
                            return new Entry(next.getKey(), next.getValue());
                        }
                        return (Entry)this.endOfData();
                    }
                };
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(File checkpointDir) throws IOException {
        SharedReference localState = this.generationState.getCopy();
        try {
            if (localState == null) {
                throw new IOException("store is closed");
            }
            checkpointDir.mkdirs();
            ((GenerationState)localState.get()).volatileGeneration.checkpoint(checkpointDir);
            for (Generation generation : ((GenerationState)localState.get()).stableGenerations) {
                generation.checkpoint(checkpointDir);
            }
            PosixFileOperations.cplr((File)new File(((GenerationState)localState.get()).path, "state"), (File)checkpointDir);
        }
        finally {
            Closeables2.closeQuietly((Closeable)localState, (Logger)log);
        }
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    private File getNextDataFile() throws IOException {
        return new File(this.dataDir, String.valueOf(this.getUniqueTimestamp()));
    }

    private File getNextLogFile() throws IOException {
        return new File(this.dataDir, this.getUniqueTimestamp() + ".log");
    }

    private File getNextCheckpointDir() throws IOException {
        return new File(this.root, String.valueOf(this.getUniqueTimestamp()));
    }

    private long getUniqueTimestamp() throws IOException {
        long time;
        long lastUsedTime;
        do {
            if ((time = System.currentTimeMillis()) > (lastUsedTime = this.lastUsedTimeStamp.get())) continue;
            time = lastUsedTime + 1L;
        } while (!this.lastUsedTimeStamp.compareAndSet(lastUsedTime, time));
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointGenerationState(GenerationState<K, V> state, File checkpointDir) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> stableGenerationNames = new ArrayList<String>();
        for (Generation generation : ((GenerationState)state).stableGenerations) {
            File generationPath = generation.getPath();
            String generationName = generationPath.getName();
            stableGenerationNames.add(generationName);
            PosixFileOperations.link((File)generationPath, (File)new File(checkpointDir, generationName));
        }
        map.put("stableGenerations", stableGenerationNames);
        File volatileGenerationPath = ((GenerationState)state).volatileGeneration.getPath();
        String volatileGenerationName = volatileGenerationPath.getName();
        map.put("volatileGeneration", volatileGenerationName);
        PosixFileOperations.link((File)volatileGenerationPath, (File)new File(checkpointDir, volatileGenerationName));
        Yaml yaml = new Yaml();
        String generationStateString = yaml.dump(map);
        RandomAccessFile raf = null;
        FileChannel channel = null;
        try {
            raf = new RandomAccessFile(new File(checkpointDir, "state"), "rw");
            channel = raf.getChannel();
            byte[] bytes = generationStateString.getBytes(Charsets.UTF_8);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            while (buffer.remaining() > 0) {
                channel.write(buffer);
            }
            channel.force(true);
        }
        catch (Throwable throwable) {
            Closeables2.closeQuietly(channel, (Logger)log);
            Closeables2.closeQuietly(raf, (Logger)log);
            throw throwable;
        }
        Closeables2.closeQuietly((Closeable)channel, (Logger)log);
        Closeables2.closeQuietly((Closeable)raf, (Logger)log);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.compactor != null) {
            Closeables2.closeQuietly((Closeable)this.compactor, (Logger)log);
        } else {
            Closeables2.closeQuietly((Closeable)this.generationState.getAndUnset(), (Logger)log);
        }
        if (this.lockFile != null) {
            this.lockFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        SharedReference localState = this.generationState.getCopy();
        try {
            if (localState == null) {
                throw new IOException("store is closed");
            }
            try {
                ((GenerationState)localState.get()).volatileGeneration.sync();
            }
            catch (IOException e) {
                this.compactor.compact();
                throw e;
            }
        }
        finally {
            Closeables2.closeQuietly((Closeable)localState, (Logger)log);
        }
    }

    public void waitForCompactions() throws InterruptedException {
        this.compactor.waitForCompletion();
    }

    public long getActiveSpaceUsage() throws IOException {
        return this.doWithState(this.getActiveSpaceUsage, null);
    }

    public long getTotalSpaceUsage() throws IOException {
        return this.doWithState(this.getTotalSpaceUsage, null);
    }

    public long getReservedSpaceUsage() {
        return this.reservedCompactionSpace.get();
    }

    public long getFreeSpace() throws IOException {
        return this.getFreeSpace(this.getReservedSpaceUsage() + this.reservedSpaceThreshold);
    }

    private long getFreeSpace(long reservedSpace) throws IOException {
        long tmpSpace = NativeFileUtils.du((File)this.root.getCanonicalFile()) - this.getTotalSpaceUsage();
        return this.root.getUsableSpace() - reservedSpace + tmpSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Generation<K, V> doCompaction(List<Generation<K, V>> toCompact, boolean hasDeletions) throws IOException {
        long spaceToReserve = 0L;
        for (Generation<K, V> generation : toCompact) {
            spaceToReserve += generation.sizeInBytes();
        }
        long reservedSpace = this.reservedCompactionSpace.addAndGet(spaceToReserve);
        try {
            if (this.dedicatedPartition && this.getFreeSpace(reservedSpace + this.reservedSpaceThreshold) < 0L) {
                throw new IOException("Out of disk space!");
            }
            File file = this.getNextDataFile();
            StableGeneration.Writer.write(this.memoryManager, file, toCompact, this.keySerializer, this.valueSerializer, this.comparator, this.storageType, this.codec, hasDeletions);
            Generation<K, V> generation = StableGeneration.open(this.memoryManager, file, this.comparator, this.keySerializer, this.valueSerializer, this.storageType, this.codec, this.mlockFiles);
            this.totalGenerationSpace.addAndGet(generation.sizeInBytes());
            Generation<K, V> generation2 = generation;
            return generation2;
        }
        finally {
            this.reservedCompactionSpace.addAndGet(-spaceToReserve);
        }
    }

    public static final class Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static final class GenerationState<K, V>
    implements Closeable {
        private final List<SharedReference<? extends Generation<K, V>>> stableGenerationReferences;
        private final SharedReference<VolatileGeneration<K, V>> volatileGenerationReference;
        private final List<Generation<K, V>> stableGenerations;
        private final VolatileGeneration<K, V> volatileGeneration;
        private final File path;

        public GenerationState(List<SharedReference<? extends Generation<K, V>>> stableGenerationReferences, SharedReference<VolatileGeneration<K, V>> volatileGenerationReference, File path) {
            this.path = path;
            this.stableGenerationReferences = ImmutableList.copyOf(stableGenerationReferences);
            this.volatileGenerationReference = volatileGenerationReference;
            this.volatileGeneration = (VolatileGeneration)volatileGenerationReference.get();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SharedReference<Generation<K, V>> sharedReference : stableGenerationReferences) {
                builder.add(sharedReference.get());
            }
            this.stableGenerations = builder.build();
        }

        public void delete() throws IOException {
            log.info((Object)("deleting " + this.path));
            PosixFileOperations.rmrf((File)this.path);
        }

        @Override
        public void close() throws IOException {
            Closeables2.closeQuietly(this.volatileGenerationReference, (Logger)log);
            for (SharedReference<? extends Generation<K, V>> sharedReference : this.stableGenerationReferences) {
                Closeables2.closeQuietly(sharedReference, (Logger)log);
            }
        }
    }

    private final class Compactor
    implements Closeable {
        final ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("compaction-thread-%d").setDaemon(true).build());
        final ReentrantLock lock = new ReentrantLock();
        final Condition compactionStateChanged = this.lock.newCondition();
        final Set<String> currentlyCompacting = new HashSet<String>();
        volatile boolean closed = false;
        volatile int runningCompactions = 0;

        private Compactor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compact() throws IOException {
            block10: {
                this.lock.lock();
                try {
                    if (this.closed) break block10;
                    SharedReference localStateReference = Store.this.generationState.getCopy();
                    try {
                        if (localStateReference == null) {
                            return;
                        }
                        GenerationState localState = (GenerationState)localStateReference.get();
                        if (localState.volatileGeneration.sizeInBytes() > Store.this.maxVolatileGenerationSize) {
                            GenerationState nextState = this.startNewLog(localState);
                            this.startCompaction(nextState);
                        }
                    }
                    finally {
                        Closeables2.closeQuietly((Closeable)localStateReference, (Logger)log);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private GenerationState<K, V> startNewLog(GenerationState<K, V> localState) throws IOException {
            File newLog = Store.this.getNextLogFile();
            VolatileGeneration nextVolatileGeneration = new VolatileGeneration(newLog, Store.this.keySerializer, Store.this.valueSerializer, Store.this.comparator);
            ArrayList nextStableGenerations = Lists.newArrayList();
            nextStableGenerations.add(localState.volatileGenerationReference.copy());
            for (SharedReference reference : localState.stableGenerationReferences) {
                nextStableGenerations.add(reference.copy());
            }
            File checkpointDir = Store.this.getNextCheckpointDir();
            checkpointDir.mkdirs();
            GenerationState nextState = new GenerationState(nextStableGenerations, SharedReference.create(nextVolatileGeneration), checkpointDir);
            Store.this.checkpointGenerationState(nextState, checkpointDir);
            localState.volatileGeneration.closeWriter();
            PosixFileOperations.atomicLink((File)checkpointDir, (File)new File(Store.this.root, "latest"));
            SharedReference oldState = (SharedReference)Preconditions.checkNotNull((Object)Store.this.generationState.getAndSet(nextState));
            ((GenerationState)oldState.get()).delete();
            Closeables2.closeQuietly((Closeable)oldState, (Logger)log);
            return nextState;
        }

        private void startCompaction(GenerationState<K, V> localState) throws IOException {
            ArrayList toCompact = Lists.newArrayList();
            long sum = 0L;
            boolean hasDeletions = false;
            for (SharedReference reference : localState.stableGenerationReferences) {
                Generation generation = (Generation)reference.get();
                String name = generation.getPath().getName();
                if (!this.currentlyCompacting.contains(name)) {
                    if (generation instanceof VolatileGeneration || sum * 2L > generation.sizeInBytes()) {
                        sum += generation.sizeInBytes();
                        toCompact.add(reference.copy());
                        this.currentlyCompacting.add(generation.getPath().getName());
                        continue;
                    }
                    hasDeletions = true;
                    break;
                }
                hasDeletions = true;
                break;
            }
            if (toCompact.size() > 0) {
                ++this.runningCompactions;
                this.threadPool.execute(new Compaction(toCompact, hasDeletions));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.closed = true;
                if (this.runningCompactions == 0) {
                    this.finishClose();
                }
            }
            finally {
                this.compactionStateChanged.signalAll();
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishClose() throws IOException {
            try {
                SharedReference state = Store.this.generationState.getAndUnset();
                try {
                    VolatileGeneration volatileGeneration;
                    if (state != null && (volatileGeneration = ((GenerationState)state.get()).volatileGeneration) != null) {
                        volatileGeneration.closeWriter();
                    }
                }
                finally {
                    Closeables2.closeQuietly((Closeable)state, (Logger)log);
                }
            }
            finally {
                this.threadPool.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() throws InterruptedException {
            while (true) {
                this.lock.lock();
                try {
                    if (this.closed && this.runningCompactions == 0) {
                        return;
                    }
                    this.compactionStateChanged.await();
                    continue;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        private final class Compaction
        implements Runnable {
            private final List<SharedReference<? extends Generation<K, V>>> toCompact;
            private final boolean hasDeletions;

            private Compaction(List<SharedReference<? extends Generation<K, V>>> toCompact, boolean hasDeletions) {
                this.toCompact = toCompact;
                this.hasDeletions = hasDeletions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean locked = false;
                HashSet<String> compactedGenerations = new HashSet<String>();
                for (SharedReference sharedReference : this.toCompact) {
                    compactedGenerations.add(((Generation)sharedReference.get()).getPath().getName());
                }
                try {
                    ArrayList toCompactGenerations = Lists.newArrayList();
                    for (SharedReference sharedReference : this.toCompact) {
                        toCompactGenerations.add(sharedReference.get());
                    }
                    Generation generation = Store.this.doCompaction(toCompactGenerations, this.hasDeletions);
                    Compactor.this.lock.lock();
                    locked = true;
                    this.finishCompaction(compactedGenerations, toCompactGenerations, generation);
                }
                catch (Throwable e) {
                    if (!locked) {
                        Compactor.this.lock.lock();
                        locked = true;
                    }
                    Compactor.this.currentlyCompacting.removeAll(compactedGenerations);
                    log.error((Object)"exception during compaction", e);
                    throw Throwables.propagate((Throwable)e);
                }
                finally {
                    block21: {
                        if (!locked) {
                            Compactor.this.lock.lock();
                        }
                        try {
                            for (SharedReference sharedReference : this.toCompact) {
                                Closeables2.closeQuietly(sharedReference, (Logger)log);
                            }
                            --Compactor.this.runningCompactions;
                            if (Compactor.this.runningCompactions < 0) {
                                log.error((Object)("compactions count is " + Compactor.this.runningCompactions + ", this is bad."));
                            }
                            if (!Compactor.this.closed || Compactor.this.runningCompactions != 0) break block21;
                            try {
                                Compactor.this.finishClose();
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                        finally {
                            Compactor.this.compactionStateChanged.signalAll();
                            Compactor.this.lock.unlock();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void finishCompaction(Set<String> compactedGenerations, List<Generation<K, V>> toCompactGenerations, Generation<K, V> stableGeneration) throws IOException {
                ArrayList nextStableGenerations = Lists.newArrayList();
                SharedReference stateReference = (SharedReference)Preconditions.checkNotNull((Object)Store.this.generationState.getCopy());
                GenerationState state = (GenerationState)stateReference.get();
                try {
                    boolean compactionAdded = false;
                    for (SharedReference reference : state.stableGenerationReferences) {
                        String name = ((Generation)reference.get()).getPath().getName();
                        if (!compactedGenerations.contains(name)) {
                            nextStableGenerations.add(reference.copy());
                            continue;
                        }
                        if (!compactionAdded) {
                            nextStableGenerations.add(SharedReference.create(stableGeneration));
                            compactionAdded = true;
                        }
                        Compactor.this.currentlyCompacting.remove(name);
                    }
                    File checkpointDir = Store.this.getNextCheckpointDir();
                    checkpointDir.mkdirs();
                    GenerationState nextState = new GenerationState(nextStableGenerations, state.volatileGenerationReference.copy(), checkpointDir);
                    Store.this.checkpointGenerationState(nextState, checkpointDir);
                    PosixFileOperations.atomicLink((File)checkpointDir, (File)new File(Store.this.root, "latest"));
                    SharedReference oldState = (SharedReference)Preconditions.checkNotNull((Object)Store.this.generationState.getAndSet(nextState));
                    ((GenerationState)oldState.get()).delete();
                    Closeables2.closeQuietly((Closeable)oldState, (Logger)log);
                    for (Generation generation : toCompactGenerations) {
                        long sizeInBytes = generation.sizeInBytes();
                        generation.delete();
                        Store.this.totalGenerationSpace.addAndGet(-sizeInBytes);
                    }
                }
                finally {
                    Closeables2.closeQuietly((Closeable)stateReference, (Logger)log);
                }
            }
        }
    }

    private final class Process<A>
    extends F2<GenerationState<K, V>, P4<Processor<Entry<K, V>, A>, K, Boolean, Boolean>, A> {
        private Process() {
        }

        public A f(GenerationState<K, V> kvGenerationState, P4<Processor<Entry<K, V>, A>, K, Boolean, Boolean> p) {
            return (A)Enumerator.runOnce((Processor)p._1(), Store.this.stream(kvGenerationState, p._2(), (Boolean)p._3(), (Boolean)p._4()))._1();
        }
    }
}

