/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.lsmtree.core;

import com.google.common.collect.Ordering;
import com.indeed.lsmtree.core.FilteredGeneration;
import com.indeed.lsmtree.core.Generation;
import com.indeed.util.core.reference.SharedReference;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class ReverseGeneration<K, V>
implements Generation<K, V> {
    private static final Logger log = Logger.getLogger(ReverseGeneration.class);
    private final Generation<K, V> wrapped;
    private final SharedReference<Closeable> closeable;

    public ReverseGeneration(Generation<K, V> wrapped, SharedReference<Closeable> closeable) {
        this.wrapped = wrapped;
        this.closeable = closeable;
    }

    @Override
    public Generation.Entry<K, V> get(K key) {
        return this.wrapped.get(key);
    }

    @Override
    public Boolean isDeleted(K key) {
        return this.wrapped.isDeleted(key);
    }

    @Override
    public Generation<K, V> head(K end, boolean inclusive) {
        return new FilteredGeneration(this, (SharedReference<Closeable>)this.closeable.copy(), null, false, end, inclusive);
    }

    @Override
    public Generation<K, V> tail(K start, boolean inclusive) {
        return new FilteredGeneration(this, (SharedReference<Closeable>)this.closeable.copy(), start, inclusive, null, false);
    }

    @Override
    public Generation<K, V> slice(K start, boolean startInclusive, K end, boolean endInclusive) {
        return new FilteredGeneration(this, (SharedReference<Closeable>)this.closeable.copy(), start, startInclusive, end, endInclusive);
    }

    @Override
    public Generation<K, V> reverse() {
        return this.wrapped;
    }

    @Override
    public Iterator<Generation.Entry<K, V>> iterator() {
        return this.wrapped.reverseIterator();
    }

    @Override
    public Iterator<Generation.Entry<K, V>> iterator(K start, boolean startInclusive) {
        return this.wrapped.reverseIterator(start, startInclusive);
    }

    @Override
    public Iterator<Generation.Entry<K, V>> reverseIterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Iterator<Generation.Entry<K, V>> reverseIterator(K start, boolean startInclusive) {
        return this.wrapped.iterator(start, startInclusive);
    }

    @Override
    public Comparator<K> getComparator() {
        return Ordering.from(this.wrapped.getComparator()).reverse();
    }

    @Override
    public long size() throws IOException {
        return this.wrapped.size();
    }

    @Override
    public long sizeInBytes() throws IOException {
        return this.wrapped.sizeInBytes();
    }

    @Override
    public boolean hasDeletions() {
        return this.wrapped.hasDeletions();
    }

    @Override
    public File getPath() {
        return this.wrapped.getPath();
    }

    @Override
    public void checkpoint(File checkpointPath) throws IOException {
        this.wrapped.checkpoint(checkpointPath);
    }

    @Override
    public void delete() throws IOException {
        this.wrapped.delete();
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }
}

