/*
 * Decompiled with CFR 0.152.
 */
package com.incapptic.plugins.connect;

import com.incapptic.plugins.connect.ArtifactsNotFoundException;
import com.incapptic.plugins.connect.IncappticServerException;
import com.incapptic.plugins.connect.MultipleArtifactsException;
import com.incapptic.plugins.connect.OutputUtils;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Proxy;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ConnectNotifier
extends Recorder
implements Serializable,
SimpleBuildStep {
    public static final String TOKEN_HEADER_NAME = "X-Connect-Token";
    private static final long serialVersionUID = 1L;
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/octet-stream");
    private String token;
    private String url;
    private Integer appId;
    private String mask;
    private Boolean useMasterProxy;
    private Boolean verboseLogging;

    @DataBoundConstructor
    public ConnectNotifier(String token, String url, Integer appId, String mask, Boolean useMasterProxy, Boolean verboseLogging) {
        this.token = token;
        this.url = url;
        this.appId = appId;
        this.mask = mask;
        this.useMasterProxy = useMasterProxy;
        this.verboseLogging = verboseLogging;
    }

    public String getToken() {
        return this.token;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getAppId() {
        return this.appId;
    }

    public Boolean getUseMasterProxy() {
        return this.useMasterProxy;
    }

    public Boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    public String getMask() {
        return this.mask;
    }

    private String getToken(@Nonnull Run<?, ?> run) {
        Object tokenValue;
        if (StringUtils.isEmpty((String)this.getToken()) && (tokenValue = this.getParameterValue(run, "token")) != null) {
            this.token = tokenValue.toString();
        }
        return this.token;
    }

    private Object getParameterValue(@Nonnull Run<?, ?> run, String name) {
        for (Action ac : run.getAllActions()) {
            if (!(ac instanceof ParametersAction)) continue;
            ParametersAction pac = (ParametersAction)ac;
            for (ParameterValue pav : pac.getParameters()) {
                if (name == null || !name.equals(pav.getName())) continue;
                return pav.getValue();
            }
        }
        return null;
    }

    private OkHttpClient getHttpClient(String host, OutputUtils outputUtil) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            if (this.getUseMasterProxy().booleanValue()) {
                outputUtil.info("Using Jenkins Master proxy settings");
                ProxyConfiguration proxyConfiguration = instance.proxy;
                if (proxyConfiguration != null) {
                    Boolean verboseLog = this.getVerboseLogging();
                    outputUtil.verbose(String.format("Proxy test url: %s", proxyConfiguration.getTestUrl()), verboseLog);
                    outputUtil.verbose(String.format("Proxy Encrypted Password: %s", proxyConfiguration.getEncryptedPassword()), verboseLog);
                    outputUtil.verbose(String.format("Proxy UserName: %s", proxyConfiguration.getUserName()), verboseLog);
                    outputUtil.verbose(String.format("Proxy No Proxy Patterns: %s", proxyConfiguration.getNoProxyHostPatterns().toString()), verboseLog);
                    outputUtil.verbose(String.format("Proxy Port: %s", String.valueOf(proxyConfiguration.port)), verboseLog);
                    outputUtil.verbose(String.format("Proxy Name: %s", proxyConfiguration.name), verboseLog);
                    outputUtil.verbose(String.format("Proxy No Proxy Host: %s", proxyConfiguration.noProxyHost), verboseLog);
                    outputUtil.verbose(String.format("Proxy Config String: %s", proxyConfiguration.toString()), verboseLog);
                    Proxy proxy = proxyConfiguration.createProxy(host);
                    okHttpClient.setProxy(proxy);
                    outputUtil.info("Proxy connection configured.");
                } else {
                    outputUtil.info("Jenkins Master instance HAS NO PROXY INFORMATION !!!");
                }
            } else {
                outputUtil.info("Ignoring the proxy settings");
            }
        }
        return okHttpClient;
    }

    private boolean validate(@Nonnull Run<?, ?> run, OutputUtils outputUtil) {
        outputUtil.info("Incapptic Connect Jenkins Validation starting... ");
        Result result = run.getResult();
        if (result != null && result.isWorseOrEqualTo(Result.FAILURE)) {
            outputUtil.error("Cannot send artifacts from failed build.");
            return false;
        }
        if (this.getAppId() == null) {
            outputUtil.error("No appId parameter provided.");
            return false;
        }
        if (StringUtils.isEmpty((String)this.getMask())) {
            outputUtil.error("No mask parameter provided.");
            return false;
        }
        if (StringUtils.isEmpty((String)this.getToken(run))) {
            outputUtil.error("No token parameter provided.");
            return false;
        }
        if (StringUtils.isEmpty((String)this.getUrl())) {
            outputUtil.error("No url parameter provided.");
            return false;
        }
        outputUtil.success("Incapptic Connect Uploader plugin successfully validated AppId, Token, URL and Binary ");
        return true;
    }

    private MultipartBuilder getMultipartBuilder(@Nonnull FilePath filePath, @Nonnull TaskListener taskListener, OutputUtils outputUtil) {
        MultipartBuilder multipart = new MultipartBuilder();
        multipart.type(MultipartBuilder.FORM);
        try {
            byte[] bytes;
            FilePath artifact = this.getArtifact(filePath, this.getMask(), taskListener.getLogger());
            outputUtil.info(String.format("Artifact %s being sent to Incapptic Connect. ", artifact.getName()));
            String ident = String.format("artifact-%s", this.getAppId());
            File tmp = File.createTempFile(ident, "tmp");
            try (FileOutputStream os = new FileOutputStream(tmp);){
                artifact.copyTo((OutputStream)os);
            }
            var10_9 = null;
            try (FileInputStream is = new FileInputStream(tmp);){
                bytes = IOUtils.toByteArray((InputStream)is);
            }
            catch (Throwable throwable) {
                var10_9 = throwable;
                throw throwable;
            }
            RequestBody rb = RequestBody.create((MediaType)MEDIA_TYPE, (byte[])bytes);
            multipart.addFormDataPart(ident, artifact.getName(), rb);
            return multipart;
        }
        catch (MultipleArtifactsException e) {
            outputUtil.error(String.format("Multiple artifacts found for name [%s].", this.getMask()));
            return null;
        }
        catch (ArtifactsNotFoundException e) {
            outputUtil.error(String.format("No artifacts found for name [%s].", this.getMask()));
            return null;
        }
        catch (IOException e) {
            outputUtil.error(String.format("Could not read attachments for name [%s].", this.getMask()));
            return null;
        }
        catch (InterruptedException e) {
            outputUtil.error("Interrupted.");
            return null;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        OutputUtils outputUtil = OutputUtils.getLoggerForStream(taskListener.getLogger());
        Boolean verboseLog = this.getVerboseLogging();
        outputUtil.info("Connect plugin is processing build artifacts ");
        if (!this.validate(run, outputUtil)) {
            return;
        }
        outputUtil.verbose(String.format("Copying binary to folder: %s ", filePath.absolutize().getRemote()), verboseLog);
        MultipartBuilder multipartBuilder = this.getMultipartBuilder(filePath, taskListener, outputUtil);
        if (multipartBuilder == null) {
            outputUtil.error("No attachments created.");
            return;
        }
        outputUtil.verbose(String.format("Successfully coppied binary to folder: %s ", filePath.absolutize().getRemote()), verboseLog);
        outputUtil.verbose("Creating upload client ", verboseLog);
        OkHttpClient client = this.getHttpClient(this.url, outputUtil);
        outputUtil.verbose("Successfully created upload client ", verboseLog);
        Request.Builder builder = new Request.Builder();
        outputUtil.verbose("Constructing Upload Request ", verboseLog);
        builder.addHeader(TOKEN_HEADER_NAME, this.getToken());
        builder.url(this.url);
        builder.post(multipartBuilder.build());
        Request request = builder.build();
        outputUtil.verbose("Successfully Constructed Upload Request ", verboseLog);
        for (String name : request.headers().names()) {
            outputUtil.verbose(String.format("Request Head: %s parsed", name), verboseLog);
        }
        outputUtil.verbose(String.format("Request Body: %s", request.body().toString()), verboseLog);
        outputUtil.info("Executing Upload Request ");
        Response response = null;
        try {
            response = client.newCall(request).execute();
        }
        catch (IOException e) {
            outputUtil.verbose(String.format("SOMETHING WENT WRONG!!! HERE IS THE MESSAGE: %s", e.getMessage()), verboseLog);
            outputUtil.verbose(String.format("SOMETHING WENT WRONG!!! HERE IS THE LOCALIZED MESSAGE: %s", e.getLocalizedMessage()), verboseLog);
            outputUtil.verbose(String.format("SOMETHING WENT WRONG!!! HERE IS THE TOSTRING: %s", e.toString()), verboseLog);
            e.printStackTrace(outputUtil.getPrintStream());
            throw new IncappticServerException("Error executing request to incapptic Connect.");
        }
        if (response == null) {
            outputUtil.error("NULL RESPONSE OBTAINED, RETURNING!!!");
        }
        if (!response.isSuccessful()) {
            if (response.code() < 500) {
                String body = IOUtils.toString((InputStream)response.body().byteStream(), (String)"UTF-8");
                outputUtil.error(String.format("Endpoint %s replied with code %d and message [%s].", this.getUrl(), response.code(), body));
                throw new IncappticServerException("Error while uploading to incapptic Connect");
            }
            outputUtil.error(String.format("Endpoint %s replied with code %d.", this.getUrl(), response.code()));
            throw new IncappticServerException("Error while uploading to incapptic Connect");
        }
        outputUtil.verbose("Successfully Executed Upload Request ", verboseLog);
        outputUtil.success(response.body().string());
        outputUtil.success("All artifacts sent to Connect");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            return false;
        }
        try {
            this.perform((Run<?, ?>)build, workspace, launcher, (TaskListener)listener);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    private FilePath getArtifact(FilePath workspace, String glob, PrintStream logger) throws MultipleArtifactsException, ArtifactsNotFoundException, IOException, InterruptedException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s", glob));
        ArrayList<FilePath> artifacts = new ArrayList<FilePath>();
        this.getArtifacts(workspace, "", matcher, artifacts, logger);
        if (artifacts.size() == 0) {
            throw new ArtifactsNotFoundException();
        }
        if (artifacts.size() > 1) {
            throw new MultipleArtifactsException();
        }
        return (FilePath)artifacts.get(0);
    }

    private void getArtifacts(FilePath parent, String base, PathMatcher matcher, List<FilePath> artifacts, PrintStream logger) throws IOException, InterruptedException {
        for (FilePath child : parent.list()) {
            if (child.isDirectory()) {
                this.getArtifacts(child, String.format("%s/%s", base, child.getName()), matcher, artifacts, logger);
                continue;
            }
            Path path = Paths.get(base, child.getName());
            if (!matcher.matches(path)) continue;
            artifacts.add(child);
        }
    }

    @Extension(ordinal=-1.0)
    @Symbol(value={"uploadToIncappticConnect"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(ConnectNotifier.class);
        }

        public String getDisplayName() {
            return "Incapptic Connect Publisher";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckToken(@QueryParameter String token) {
            if (StringUtils.isEmpty((String)token)) {
                return FormValidation.error((String)"Empty token");
            }
            return FormValidation.ok();
        }
    }
}

