/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.jdbc.spy;

import com.impossibl.jdbc.spy.ConnectionListener;
import com.impossibl.jdbc.spy.ConnectionRelay;
import com.impossibl.jdbc.spy.ListenerFactory;
import com.impossibl.jdbc.spy.TracerFactory;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;

public class SpyDriver
implements Driver {
    private static SpyDriver registered;

    private String getTargetDriverUrl(String url) {
        return "jdbc" + url.substring(8);
    }

    private Driver getTargetDriver(String url) throws SQLException {
        return DriverManager.getDriver(this.getTargetDriverUrl(url));
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ListenerFactory spyFactory;
        if (!url.startsWith("jdbc:spy")) {
            return null;
        }
        Driver driver = this.getTargetDriver(url);
        String spyFactoryClassName = info.getProperty("spy.factory", System.getProperty("spy.factory", TracerFactory.class.getName()));
        info.remove("spy.factory");
        try {
            Class<?> spyFactoryClass = Class.forName(spyFactoryClassName);
            spyFactory = (ListenerFactory)spyFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SQLException("SPY: Unable to instantiate Spy ListenerFactory: " + spyFactoryClassName, e);
        }
        ConnectionListener connectionListener = spyFactory.newConnectionListener(info);
        Connection connection = driver.connect(this.getTargetDriverUrl(url), info);
        return new ConnectionRelay(connection, connectionListener);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:spy") && this.getTargetDriver(url).acceptsURL(this.getTargetDriverUrl(url));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] propertyInfos = this.getTargetDriver(url).getPropertyInfo(url, info);
        propertyInfos = Arrays.copyOf(propertyInfos, propertyInfos.length + 1);
        propertyInfos[propertyInfos.length - 1] = new DriverPropertyInfo("spy.trace.url", info.getProperty("spy.trace.url"));
        return propertyInfos;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            registered = new SpyDriver();
            DriverManager.registerDriver(registered);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

