/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.CoreTestUtilities;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.DummyDatabase;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.polyglot.entities.AddressB1M;
import com.impetus.kundera.polyglot.entities.AddressBM1;
import com.impetus.kundera.polyglot.entities.PersonB1M;
import com.impetus.kundera.polyglot.entities.PersonBM1;
import com.impetus.kundera.query.CoreQuery;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.query.KunderaQueryParser;
import com.impetus.kundera.query.Person;
import com.impetus.kundera.utils.KunderaCoreUtils;
import com.impetus.kundera.utils.LuceneCleanupUtilities;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.TemporalType;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QueryImplTest {
    private static final String PU = "patest";
    private EntityManagerFactory emf;
    private EntityManager em;
    private EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;
    Map propertyMap = null;

    @Before
    public void setUp() throws Exception {
        this.propertyMap = new HashMap();
        this.propertyMap.put("index.home.dir", "./lucene");
        this.emf = Persistence.createEntityManagerFactory((String)PU, (Map)this.propertyMap);
        this.kunderaMetadata = ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance();
        this.em = this.emf.createEntityManager();
    }

    @Test
    public void test() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Person p1 = new Person();
        p1.setAge(98);
        p1.setPersonId("1");
        p1.setDay(Person.Day.SATURDAY);
        p1.setSalary(Double.valueOf(6000.345));
        this.em.persist((Object)p1);
        Person p2 = new Person();
        p2.setAge(100);
        p2.setPersonId("2");
        p2.setDay(Person.Day.SATURDAY);
        p2.setSalary(Double.valueOf(10000.345));
        this.em.persist((Object)p2);
        String query = "Select p from Person p where p.personId = :personId";
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        KunderaQuery kunderaQuery = this.parseQuery(query);
        CoreQuery queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("personId", (Object)"1");
        List results = queryObj.getResultList();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        String deleteQuery = "Delete from Person p where p.personId = ?1";
        kunderaQuery = this.parseQuery("Delete from Person p where p.personId = ?1");
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        try {
            Assert.assertNull((Object)queryObj.getParameter("personId", String.class));
        }
        catch (IllegalArgumentException iaex) {
            Assert.assertEquals((String)"The parameter of the specified name does not exist or is not assignable to the type", (String)iaex.getMessage());
        }
        Assert.assertNotNull((Object)queryObj.getParameter(1, String.class));
        Assert.assertNotNull((Object)queryObj.getParameterValue(1));
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        try {
            queryObj.getParameterValue(1);
        }
        catch (IllegalStateException usex) {
            Assert.assertEquals((String)"parameter has not been bound1", (String)usex.getMessage());
        }
        queryObj.setParameter(1, (Object)"1");
        queryObj.executeUpdate();
        this.em.clear();
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        try {
            queryObj.setParameter(CoreTestUtilities.getParameter(), (Object)"test");
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (IllegalArgumentException iaex) {
            Assert.assertNotNull((Object)iaex);
        }
        try {
            queryObj.setParameter(CoreTestUtilities.getParameter((String)"personId", (Object)"1"), (Object)"1");
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (IllegalArgumentException iaex) {
            Assert.assertNotNull((Object)iaex);
        }
        queryObj.setParameter(queryObj.getParameter("personId"), (Object)"1");
        results = queryObj.getResultList();
        Assert.assertEquals((int)0, (int)results.size());
        queryObj.setHint("test", (Object)"test");
        queryObj.setMaxResults(100);
        Assert.assertEquals((int)100, (int)queryObj.getMaxResults());
        Assert.assertNotNull((Object)queryObj.getHints());
        queryObj.setFetchSize(Integer.valueOf(100));
        Assert.assertEquals((Object)new Integer(100), (Object)queryObj.getFetchSize());
        query = "Select p from Person p where p.personId = ?1";
        queryObj.setParameter(queryObj.getParameter("personId"), (Object)"1");
        results = queryObj.getResultList();
        Assert.assertEquals((int)0, (int)results.size());
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        Assert.assertNotNull((Object)queryObj.getParameter("personId", String.class));
        Assert.assertTrue((boolean)queryObj.isBound(queryObj.getParameter("personId", String.class)));
        Assert.assertNotNull((Object)queryObj.getParameterValue(queryObj.getParameter("personId", String.class)));
        Assert.assertNotNull((Object)queryObj.getParameterValue("personId"));
        try {
            Assert.assertNull((Object)queryObj.getParameter(1, String.class));
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (IllegalArgumentException iaex) {
            Assert.assertNotNull((Object)iaex);
        }
        try {
            queryObj.getParameter(1);
        }
        catch (IllegalArgumentException iaex) {
            Assert.assertNotNull((Object)iaex);
        }
        try {
            ApplicationMetadata appMetadata = ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance().getApplicationMetadata();
            appMetadata.addQueryToCollection(query, query, true, null);
            kunderaQuery = this.parseQuery(query);
            queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
            Assert.assertNull((Object)queryObj.getParameter(1, String.class));
            Assert.fail((String)"Should have gone to catch block!");
        }
        catch (IllegalStateException iaex) {
            Assert.assertEquals((String)"invoked on a native query when the implementation does not support this use", (String)iaex.getMessage());
        }
        try {
            String updateQuery = "Update Person p set p.personName=Amresh where p.personId = 1";
            kunderaQuery = this.parseQuery("Update Person p set p.personName=Amresh where p.personId = 1");
            queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
            queryObj.executeUpdate();
            Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
            Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            queryObj.unwrap(Client.class);
        }
        catch (ClassCastException usex) {
            Assert.assertEquals((String)("Provider does not support the call for class type:[" + Integer.class + "]"), (String)usex.getMessage());
        }
        try {
            queryObj.getParameterValue("invalidParameter");
        }
        catch (IllegalArgumentException usex) {
            Assert.assertEquals((String)"Parameter is not a parameter of the query.", (String)usex.getMessage());
        }
        query = "Select p from Person p where p.age >:age";
        delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("age", (Object)new Integer(32));
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        query = "Select p from Person p where p.age >=:age";
        delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("age", (Object)new Integer(32));
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        query = "Select p from Person p where p.age <:age";
        delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("age", (Object)new Integer(32));
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        query = "Select p from Person p where p.age <=:age";
        delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("age", (Object)new Integer(32));
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        query = "Select p from Person p where p.personName like :personName";
        delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("personName", (Object)"Amresh");
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        query = "Select p from Person p where p.salary >=:salary";
        delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        queryObj.setParameter("salary", (Object)500.0);
        Assert.assertNotNull((Object)KunderaCoreUtils.getLuceneQueryFromJPAQuery((KunderaQuery)kunderaQuery, (EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata));
        Assert.assertNotNull((Object)queryObj.populateUsingLucene());
        this.onassertBi1MAssociation(delegator);
        this.onassertBiM1Association(delegator);
    }

    private void onassertBi1MAssociation(PersistenceDelegator delegator) {
        PersonB1M personBi1M = new PersonB1M();
        personBi1M.setPersonId("personBi1M1");
        personBi1M.setPersonName("impetus-opensource");
        AddressB1M addressBi1M = new AddressB1M();
        addressBi1M.setAddressId("addrBi1M1");
        addressBi1M.setStreet("meri gali");
        HashSet<AddressB1M> addresses = new HashSet<AddressB1M>();
        addresses.add(addressBi1M);
        AddressB1M addressBi1M_copy = new AddressB1M();
        addressBi1M_copy.setAddressId("addrBi1M2");
        addressBi1M_copy.setStreet("meri gali");
        addresses.add(addressBi1M_copy);
        personBi1M.setAddresses(addresses);
        this.em.persist((Object)personBi1M);
        this.em.clear();
        String query = "Select p from PersonB1M p where p.personId = 'personBi1M1'";
        KunderaQuery kunderaQuery = this.parseQuery(query);
        CoreQuery queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        List associationResults = queryObj.getResultList();
        Assert.assertTrue((!associationResults.isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((PersonB1M)associationResults.get(0)).getAddresses());
        Assert.assertEquals((int)2, (int)((PersonB1M)associationResults.get(0)).getAddresses().size());
        query = "Select p from PersonB1M p where p.personId = 'invalid'";
        kunderaQuery = this.parseQuery(query);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        associationResults = queryObj.getResultList();
        Assert.assertTrue((boolean)associationResults.isEmpty());
    }

    private void onassertBiM1Association(PersistenceDelegator delegator) {
        PersonBM1 personBiM11 = new PersonBM1();
        personBiM11.setPersonId("personBiM11");
        personBiM11.setPersonName("impetus-opensource");
        PersonBM1 personBiM12 = new PersonBM1();
        personBiM12.setPersonId("personBiM12");
        personBiM12.setPersonName("impetus-opensource");
        AddressBM1 addressBiM1 = new AddressBM1();
        addressBiM1.setAddressId("addrBiM11");
        addressBiM1.setStreet("meri gali");
        personBiM11.setAddress(addressBiM1);
        personBiM12.setAddress(addressBiM1);
        this.em.persist((Object)personBiM11);
        this.em.persist((Object)personBiM12);
        this.em.clear();
        String selectAssociationQuery = "Select p from PersonBM1 p";
        KunderaQuery kunderaQuery = this.parseQuery(selectAssociationQuery);
        CoreQuery queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        List associationResults = queryObj.getResultList();
        Assert.assertTrue((!associationResults.isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((PersonBM1)associationResults.get(0)).getAddress());
        selectAssociationQuery = "Select p from PersonBM1 p where p.personId = 'invalid'";
        kunderaQuery = this.parseQuery(selectAssociationQuery);
        queryObj = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        associationResults = queryObj.getResultList();
        Assert.assertTrue((boolean)associationResults.isEmpty());
        try {
            queryObj.getSingleResult();
        }
        catch (NoResultException e) {
            Assert.assertEquals((String)"No result found!", (String)e.getMessage());
        }
    }

    private KunderaQuery parseQuery(String query) {
        KunderaQuery kunderaQuery = new KunderaQuery(query, this.kunderaMetadata);
        KunderaQueryParser queryParser = new KunderaQueryParser(kunderaQuery);
        queryParser.parse();
        kunderaQuery.postParsingInit();
        return kunderaQuery;
    }

    @After
    public void tearDown() {
        DummyDatabase.INSTANCE.dropDatabase();
        LuceneCleanupUtilities.cleanLuceneDirectory((PersistenceUnitMetadata)((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance().getApplicationMetadata().getPersistenceUnitMetadata(PU));
    }

    @Test
    public void assertOnUnsupportedMethod() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String queryStr = "Select p from Person p where p.personId = :personId";
        PersistenceDelegator delegator = CoreTestUtilities.getDelegator((EntityManager)this.em);
        KunderaQuery kunderaQuery = this.parseQuery(queryStr);
        CoreQuery query = new CoreQuery(kunderaQuery, delegator, ((EntityManagerFactoryImpl)this.emf).getKunderaMetadataInstance());
        try {
            query.setFlushMode(FlushModeType.AUTO);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setFlushMode is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setFirstResult(1);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setFirstResult is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.getFirstResult();
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"getFirstResult is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setLockMode(LockModeType.NONE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setLockMode is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.getLockMode();
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"getLockMode is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setParameter(0, new Date(), TemporalType.DATE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setParameter is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setParameter("param", new Date(), TemporalType.DATE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setParameter is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setParameter(0, Calendar.getInstance(), TemporalType.DATE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setParameter is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setParameter("param", Calendar.getInstance(), TemporalType.DATE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setParameter is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setParameter(CoreTestUtilities.getParameter(), Calendar.getInstance(), TemporalType.DATE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setParameter is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.setParameter(CoreTestUtilities.getParameter(), new Date(), TemporalType.DATE);
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"setParameter is unsupported by Kundera", (String)usex.getMessage());
        }
        try {
            query.getFlushMode();
        }
        catch (UnsupportedOperationException usex) {
            Assert.assertEquals((String)"getFlushMode is unsupported by Kundera", (String)usex.getMessage());
        }
    }
}

