/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressBM1;
import com.impetus.kundera.polyglot.entities.PersonBM1;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MOBPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonBM1 person1 = new PersonBM1();
        person1.setPersonId("bimanytoone_1");
        person1.setPersonName("Amresh");
        PersonBM1 person2 = new PersonBM1();
        person2.setPersonId("bimanytoone_2");
        person2.setPersonName("Vivek");
        AddressBM1 address = new AddressBM1();
        address.setAddressId("bimanytoone_b");
        address.setStreet("AAAAAAAAAAAAA");
        person1.setAddress(address);
        person2.setAddress(address);
        HashSet<PersonBM1> persons = new HashSet<PersonBM1>();
        persons.add(person1);
        persons.add(person2);
        this.dao.savePersons(persons);
    }

    @Override
    protected void find() {
        PersonBM1 p1 = (PersonBM1)this.dao.findPerson(PersonBM1.class, (Object)"bimanytoone_1");
        this.assertPerson1(p1);
        PersonBM1 p2 = (PersonBM1)this.dao.findPerson(PersonBM1.class, (Object)"bimanytoone_2");
        this.assertPerson2(p2);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonBM1 p = (PersonBM1)this.dao.findPersonByIdColumn(PersonBM1.class, (Object)"bimanytoone_1");
        this.assertPerson1(p);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonBM1.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        PersonBM1 person = (PersonBM1)persons.get(0);
        this.assertPerson1(person);
    }

    @Override
    protected void findAddressByIdColumn() {
    }

    @Override
    protected void findAddressByStreet() {
    }

    @Override
    protected void update() {
    }

    @Override
    protected void remove() {
    }

    private void assertPerson2(PersonBM1 p2) {
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((String)"bimanytoone_2", (String)p2.getPersonId());
        Assert.assertEquals((String)"Vivek", (String)p2.getPersonName());
        AddressBM1 add2 = p2.getAddress();
        Assert.assertNotNull((Object)add2);
        Assert.assertEquals((String)"bimanytoone_b", (String)add2.getAddressId());
        Set people2 = add2.getPeople();
    }

    private void assertPerson1(PersonBM1 p1) {
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((String)"bimanytoone_1", (String)p1.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)p1.getPersonName());
        AddressBM1 add = p1.getAddress();
        Assert.assertNotNull((Object)add);
        Assert.assertEquals((String)"bimanytoone_b", (String)add.getAddressId());
        Set people = add.getPeople();
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }
}

