/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.polyglot.tests;

import com.impetus.kundera.polyglot.entities.AddressUMM;
import com.impetus.kundera.polyglot.entities.PersonUMM;
import com.impetus.kundera.polyglot.tests.PersonAddressTestBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MMUPolyglotTest
extends PersonAddressTestBase {
    @Before
    public void setUp() throws Exception {
        super.init();
    }

    @Test
    public void testCRUD() {
        this.executeAllTests();
    }

    @Override
    protected void insert() {
        PersonUMM person1 = new PersonUMM();
        person1.setPersonId("unimanytomany_1");
        person1.setPersonName("Amresh");
        PersonUMM person2 = new PersonUMM();
        person2.setPersonId("unimanytomany_2");
        person2.setPersonName("Vivek");
        AddressUMM address1 = new AddressUMM();
        address1.setAddressId("unimanytomany_a");
        address1.setStreet("AAAAAAAAAAAAA");
        AddressUMM address2 = new AddressUMM();
        address2.setAddressId("unimanytomany_b");
        address2.setStreet("BBBBBBBBBBBBBBB");
        AddressUMM address3 = new AddressUMM();
        address3.setAddressId("unimanytomany_c");
        address3.setStreet("CCCCCCCCCCC");
        HashSet<AddressUMM> person1Addresses = new HashSet<AddressUMM>();
        HashSet<AddressUMM> person2Addresses = new HashSet<AddressUMM>();
        person1Addresses.add(address1);
        person1Addresses.add(address2);
        person2Addresses.add(address2);
        person2Addresses.add(address3);
        person1.setAddresses(person1Addresses);
        person2.setAddresses(person2Addresses);
        HashSet<PersonUMM> persons = new HashSet<PersonUMM>();
        persons.add(person1);
        persons.add(person2);
        this.dao.savePersons(persons);
    }

    @Override
    protected void find() {
        PersonUMM person1 = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_1");
        this.assertPerson1(person1);
        PersonUMM person2 = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_2");
        this.assertPerson2(person2);
    }

    @Override
    protected void findPersonByIdColumn() {
        PersonUMM p1 = (PersonUMM)this.dao.findPersonByIdColumn(PersonUMM.class, (Object)"unimanytomany_1");
        this.assertPerson1(p1);
        PersonUMM p2 = (PersonUMM)this.dao.findPersonByIdColumn(PersonUMM.class, (Object)"unimanytomany_2");
        this.assertPerson2(p2);
    }

    @Override
    protected void findPersonByName() {
        List persons = this.dao.findPersonByName(PersonUMM.class, "Amresh");
        Assert.assertNotNull((Object)persons);
        Assert.assertFalse((boolean)persons.isEmpty());
        Assert.assertTrue((persons.size() == 1 ? 1 : 0) != 0);
        this.assertPerson1((PersonUMM)persons.get(0));
    }

    @Override
    protected void findAddressByIdColumn() {
        AddressUMM a = (AddressUMM)this.dao.findAddressByIdColumn(AddressUMM.class, (Object)"unimanytomany_a");
        this.assertAddressForPerson1(a);
    }

    @Override
    protected void findAddressByStreet() {
        List adds = this.dao.findAddressByStreet(AddressUMM.class, "AAAAAAAAAAAAA");
        Assert.assertNotNull((Object)adds);
        Assert.assertFalse((boolean)adds.isEmpty());
        Assert.assertTrue((adds.size() == 1 ? 1 : 0) != 0);
        this.assertAddressForPerson1((AddressUMM)adds.get(0));
    }

    @Override
    protected void update() {
        PersonUMM p1 = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_1");
        Assert.assertNotNull((Object)p1);
        p1.setPersonName("Saurabh");
        Assert.assertEquals((int)2, (int)p1.getAddresses().size());
        for (Object address : p1.getAddresses()) {
            address.setStreet("Brand New Street");
        }
        this.dao.merge((Object)p1);
        PersonUMM p1AfterMerge = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_1");
        Assert.assertNotNull((Object)p1AfterMerge);
        Assert.assertEquals((String)"Saurabh", (String)p1AfterMerge.getPersonName());
        Assert.assertEquals((int)2, (int)p1AfterMerge.getAddresses().size());
        for (Object address : p1AfterMerge.getAddresses()) {
            Assert.assertEquals((String)"Brand New Street", (String)address.getStreet());
        }
        PersonUMM p2 = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_2");
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((int)2, (int)p2.getAddresses().size());
        p2.setPersonName("Vijay");
        for (AddressUMM address : p2.getAddresses()) {
            address.setStreet("Brand New Street");
        }
        this.dao.merge((Object)p2);
        PersonUMM p2AfterMerge = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_2");
        Assert.assertNotNull((Object)p2AfterMerge);
        Assert.assertEquals((String)"Vijay", (String)p2AfterMerge.getPersonName());
        Assert.assertEquals((int)2, (int)p2AfterMerge.getAddresses().size());
        for (AddressUMM address : p2AfterMerge.getAddresses()) {
            Assert.assertEquals((String)"Brand New Street", (String)address.getStreet());
        }
    }

    @Override
    protected void remove() {
        this.dao.remove((Object)"unimanytomany_1", PersonUMM.class);
        PersonUMM person1AfterRemoval = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_1");
        Assert.assertNull((Object)person1AfterRemoval);
        this.dao.remove((Object)"unimanytomany_2", PersonUMM.class);
        PersonUMM person2AfterRemoval = (PersonUMM)this.dao.findPerson(PersonUMM.class, (Object)"unimanytomany_2");
        Assert.assertNull((Object)person2AfterRemoval);
    }

    @After
    public void tearDown() throws Exception {
        super.close();
    }

    private void assertPerson1(PersonUMM person1) {
        Assert.assertNotNull((Object)person1);
        Assert.assertEquals((String)"unimanytomany_1", (String)person1.getPersonId());
        Assert.assertEquals((String)"Amresh", (String)person1.getPersonName());
        Set addresses1 = person1.getAddresses();
        Assert.assertNotNull((Object)addresses1);
        Assert.assertFalse((boolean)addresses1.isEmpty());
        Assert.assertEquals((int)2, (int)addresses1.size());
        AddressUMM address11 = (AddressUMM)addresses1.toArray()[0];
        this.assertAddressForPerson1(address11);
        AddressUMM address12 = (AddressUMM)addresses1.toArray()[1];
        this.assertAddressForPerson1(address12);
    }

    private void assertPerson2(PersonUMM person2) {
        Assert.assertNotNull((Object)person2);
        Assert.assertEquals((String)"unimanytomany_2", (String)person2.getPersonId());
        Assert.assertEquals((String)"Vivek", (String)person2.getPersonName());
        Set addresses2 = person2.getAddresses();
        Assert.assertNotNull((Object)addresses2);
        Assert.assertFalse((boolean)addresses2.isEmpty());
        Assert.assertEquals((int)2, (int)addresses2.size());
        AddressUMM address21 = (AddressUMM)addresses2.toArray()[0];
        this.assertAddressForPerson2(address21);
        AddressUMM address22 = (AddressUMM)addresses2.toArray()[1];
        this.assertAddressForPerson2(address22);
    }

    private void assertAddressForPerson1(AddressUMM address) {
        Assert.assertNotNull((Object)address);
        Assert.assertTrue(("unimanytomany_a".equals(address.getAddressId()) || "unimanytomany_b".equals(address.getAddressId()) ? 1 : 0) != 0);
        Assert.assertTrue(("AAAAAAAAAAAAA".equals(address.getStreet()) || "BBBBBBBBBBBBBBB".equals(address.getStreet()) ? 1 : 0) != 0);
    }

    private void assertAddressForPerson2(AddressUMM address) {
        Assert.assertNotNull((Object)address);
        Assert.assertTrue(("unimanytomany_b".equals(address.getAddressId()) || "unimanytomany_b".equals(address.getAddressId()) || "unimanytomany_c".equals(address.getAddressId()) ? 1 : 0) != 0);
        Assert.assertTrue(("CCCCCCCCCCC".equals(address.getStreet()) || "BBBBBBBBBBBBBBB".equals(address.getStreet()) ? 1 : 0) != 0);
    }
}

